// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the drift information for a resource that has been checked for drift. This includes actual and expected property values for resources in which CloudFormation has detected drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Resources that don't currently support drift detection can't be checked. For a list of resources that support drift detection, see [Resources that Support Drift Detection](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
 *
 * Use DetectStackResourceDrift to detect drift on individual resources, or DetectStackDrift to detect drift on all resources in a given stack that support drift detection.
 */
public class StackResourceDrift private constructor(builder: Builder) {
    /**
     * A JSON structure containing the actual property values of the stack resource.
     *
     * For resources whose `StackResourceDriftStatus` is `DELETED`, this structure will not be present.
     */
    public val actualProperties: kotlin.String? = builder.actualProperties
    /**
     * A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters.
     *
     * For resources whose `StackResourceDriftStatus` is `DELETED`, this structure will not be present.
     */
    public val expectedProperties: kotlin.String? = builder.expectedProperties
    /**
     * The logical name of the resource specified in the template.
     */
    public val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.
     */
    public val moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = builder.moduleInfo
    /**
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs aren't enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.
     */
    public val physicalResourceIdContext: List<PhysicalResourceIdContextKeyValuePair>? = builder.physicalResourceIdContext
    /**
     * A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose `StackResourceDriftStatus` is `MODIFIED`.
     */
    public val propertyDifferences: List<PropertyDifference>? = builder.propertyDifferences
    /**
     * The type of the resource.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The ID of the stack.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * Status of the resource's actual configuration compared to its expected configuration.
     * + `DELETED`: The resource differs from its expected template configuration because the resource has been deleted.
     * + `MODIFIED`: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).
     * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
     * + `NOT_CHECKED`: CloudFormation does not currently return this value.
     */
    public val stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = builder.stackResourceDriftStatus
    /**
     * Time at which CloudFormation performed drift detection on the stack resource.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackResourceDrift = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackResourceDrift(")
        append("actualProperties=$actualProperties,")
        append("expectedProperties=$expectedProperties,")
        append("logicalResourceId=$logicalResourceId,")
        append("moduleInfo=$moduleInfo,")
        append("physicalResourceId=$physicalResourceId,")
        append("physicalResourceIdContext=$physicalResourceIdContext,")
        append("propertyDifferences=$propertyDifferences,")
        append("resourceType=$resourceType,")
        append("stackId=$stackId,")
        append("stackResourceDriftStatus=$stackResourceDriftStatus,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualProperties?.hashCode() ?: 0
        result = 31 * result + (expectedProperties?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (moduleInfo?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceIdContext?.hashCode() ?: 0)
        result = 31 * result + (propertyDifferences?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackResourceDriftStatus?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackResourceDrift

        if (actualProperties != other.actualProperties) return false
        if (expectedProperties != other.expectedProperties) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (moduleInfo != other.moduleInfo) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (physicalResourceIdContext != other.physicalResourceIdContext) return false
        if (propertyDifferences != other.propertyDifferences) return false
        if (resourceType != other.resourceType) return false
        if (stackId != other.stackId) return false
        if (stackResourceDriftStatus != other.stackResourceDriftStatus) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackResourceDrift = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A JSON structure containing the actual property values of the stack resource.
         *
         * For resources whose `StackResourceDriftStatus` is `DELETED`, this structure will not be present.
         */
        public var actualProperties: kotlin.String? = null
        /**
         * A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters.
         *
         * For resources whose `StackResourceDriftStatus` is `DELETED`, this structure will not be present.
         */
        public var expectedProperties: kotlin.String? = null
        /**
         * The logical name of the resource specified in the template.
         */
        public var logicalResourceId: kotlin.String? = null
        /**
         * Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.
         */
        public var moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = null
        /**
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs aren't enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.
         */
        public var physicalResourceIdContext: List<PhysicalResourceIdContextKeyValuePair>? = null
        /**
         * A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose `StackResourceDriftStatus` is `MODIFIED`.
         */
        public var propertyDifferences: List<PropertyDifference>? = null
        /**
         * The type of the resource.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The ID of the stack.
         */
        public var stackId: kotlin.String? = null
        /**
         * Status of the resource's actual configuration compared to its expected configuration.
         * + `DELETED`: The resource differs from its expected template configuration because the resource has been deleted.
         * + `MODIFIED`: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).
         * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
         * + `NOT_CHECKED`: CloudFormation does not currently return this value.
         */
        public var stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = null
        /**
         * Time at which CloudFormation performed drift detection on the stack resource.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackResourceDrift) : this() {
            this.actualProperties = x.actualProperties
            this.expectedProperties = x.expectedProperties
            this.logicalResourceId = x.logicalResourceId
            this.moduleInfo = x.moduleInfo
            this.physicalResourceId = x.physicalResourceId
            this.physicalResourceIdContext = x.physicalResourceIdContext
            this.propertyDifferences = x.propertyDifferences
            this.resourceType = x.resourceType
            this.stackId = x.stackId
            this.stackResourceDriftStatus = x.stackResourceDriftStatus
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackResourceDrift = StackResourceDrift(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ModuleInfo] inside the given [block]
         */
        public fun moduleInfo(block: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.Builder.() -> kotlin.Unit) {
            this.moduleInfo = aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.invoke(block)
        }
    }
}
