// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about whether the resource's actual configuration differs, or has *drifted*, from its expected configuration.
 */
public class StackResourceDriftInformation private constructor(builder: Builder) {
    /**
     * When CloudFormation last checked if the resource had drifted from its expected configuration.
     */
    public val lastCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastCheckTimestamp
    /**
     * Status of the resource's actual configuration compared to its expected configuration
     * + `DELETED`: The resource differs from its expected configuration in that it has been deleted.
     * + `MODIFIED`: The resource differs from its expected configuration.
     * + `NOT_CHECKED`: CloudFormation has not checked if the resource differs from its expected configuration.Any resources that do not currently support drift detection have a status of `NOT_CHECKED`. For more information, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     * + `IN_SYNC`: The resource's actual configuration matches its expected configuration.
     */
    public val stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = builder.stackResourceDriftStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackResourceDriftInformation(")
        append("lastCheckTimestamp=$lastCheckTimestamp,")
        append("stackResourceDriftStatus=$stackResourceDriftStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastCheckTimestamp?.hashCode() ?: 0
        result = 31 * result + (stackResourceDriftStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackResourceDriftInformation

        if (lastCheckTimestamp != other.lastCheckTimestamp) return false
        if (stackResourceDriftStatus != other.stackResourceDriftStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When CloudFormation last checked if the resource had drifted from its expected configuration.
         */
        public var lastCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of the resource's actual configuration compared to its expected configuration
         * + `DELETED`: The resource differs from its expected configuration in that it has been deleted.
         * + `MODIFIED`: The resource differs from its expected configuration.
         * + `NOT_CHECKED`: CloudFormation has not checked if the resource differs from its expected configuration.Any resources that do not currently support drift detection have a status of `NOT_CHECKED`. For more information, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
         * + `IN_SYNC`: The resource's actual configuration matches its expected configuration.
         */
        public var stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation) : this() {
            this.lastCheckTimestamp = x.lastCheckTimestamp
            this.stackResourceDriftStatus = x.stackResourceDriftStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation = StackResourceDriftInformation(this)
    }
}
