// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The user-specified preferences for how CloudFormation performs a stack set operation.
 *
 * For more information about maximum concurrent accounts and failure tolerance, see [Stack set operation options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
 */
public class StackSetOperationPreferences private constructor(builder: Builder) {
    /**
     * The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
     *
     * Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
     *
     * By default, `0` is specified.
     */
    public val failureToleranceCount: kotlin.Int? = builder.failureToleranceCount
    /**
     * The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
     *
     * When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.
     *
     * Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage`, but not both.
     *
     * By default, `0` is specified.
     */
    public val failureTolerancePercentage: kotlin.Int? = builder.failureTolerancePercentage
    /**
     * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount`.`MaxConcurrentCount` is at most one more than the `FailureToleranceCount`.
     *
     * Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     *
     * Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage`, but not both.
     *
     * By default, `1` is specified.
     */
    public val maxConcurrentCount: kotlin.Int? = builder.maxConcurrentCount
    /**
     * The maximum percentage of accounts in which to perform this operation at one time.
     *
     * When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
     *
     * Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     *
     * Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage`, but not both.
     *
     * By default, `1` is specified.
     */
    public val maxConcurrentPercentage: kotlin.Int? = builder.maxConcurrentPercentage
    /**
     * The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
     */
    public val regionConcurrencyType: aws.sdk.kotlin.services.cloudformation.model.RegionConcurrencyType? = builder.regionConcurrencyType
    /**
     * The order of the Regions in where you want to perform the stack operation.
     */
    public val regionOrder: List<String>? = builder.regionOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetOperationPreferences(")
        append("failureToleranceCount=$failureToleranceCount,")
        append("failureTolerancePercentage=$failureTolerancePercentage,")
        append("maxConcurrentCount=$maxConcurrentCount,")
        append("maxConcurrentPercentage=$maxConcurrentPercentage,")
        append("regionConcurrencyType=$regionConcurrencyType,")
        append("regionOrder=$regionOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureToleranceCount ?: 0
        result = 31 * result + (failureTolerancePercentage ?: 0)
        result = 31 * result + (maxConcurrentCount ?: 0)
        result = 31 * result + (maxConcurrentPercentage ?: 0)
        result = 31 * result + (regionConcurrencyType?.hashCode() ?: 0)
        result = 31 * result + (regionOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetOperationPreferences

        if (failureToleranceCount != other.failureToleranceCount) return false
        if (failureTolerancePercentage != other.failureTolerancePercentage) return false
        if (maxConcurrentCount != other.maxConcurrentCount) return false
        if (maxConcurrentPercentage != other.maxConcurrentPercentage) return false
        if (regionConcurrencyType != other.regionConcurrencyType) return false
        if (regionOrder != other.regionOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
         *
         * Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
         *
         * By default, `0` is specified.
         */
        public var failureToleranceCount: kotlin.Int? = null
        /**
         * The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.
         *
         * When calculating the number of accounts based on the specified percentage, CloudFormation rounds *down* to the next whole number.
         *
         * Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage`, but not both.
         *
         * By default, `0` is specified.
         */
        public var failureTolerancePercentage: kotlin.Int? = null
        /**
         * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount`.`MaxConcurrentCount` is at most one more than the `FailureToleranceCount`.
         *
         * Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         *
         * Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage`, but not both.
         *
         * By default, `1` is specified.
         */
        public var maxConcurrentCount: kotlin.Int? = null
        /**
         * The maximum percentage of accounts in which to perform this operation at one time.
         *
         * When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
         *
         * Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         *
         * Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage`, but not both.
         *
         * By default, `1` is specified.
         */
        public var maxConcurrentPercentage: kotlin.Int? = null
        /**
         * The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
         */
        public var regionConcurrencyType: aws.sdk.kotlin.services.cloudformation.model.RegionConcurrencyType? = null
        /**
         * The order of the Regions in where you want to perform the stack operation.
         */
        public var regionOrder: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences) : this() {
            this.failureToleranceCount = x.failureToleranceCount
            this.failureTolerancePercentage = x.failureTolerancePercentage
            this.maxConcurrentCount = x.maxConcurrentCount
            this.maxConcurrentPercentage = x.maxConcurrentPercentage
            this.regionConcurrencyType = x.regionConcurrencyType
            this.regionOrder = x.regionOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences = StackSetOperationPreferences(this)
    }
}
