// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * Filter criteria to use in determining which extensions to return.
 */
public class TypeFilters private constructor(builder: Builder) {
    /**
     * The category of extensions to return.
     * + `REGISTERED`: Private extensions that have been registered for this account and region.
     * + `ACTIVATED`: Public extensions that have been activated for this account and region.
     * + `THIRD_PARTY`: Extensions available for use from publishers other than Amazon. This includes:
     *    + Private extensions registered in the account.
     *    + Public extensions from publishers other than Amazon, whether activated or not.
     * + `AWS_TYPES`: Extensions available for use from Amazon.
     */
    public val category: aws.sdk.kotlin.services.cloudformation.model.Category? = builder.category
    /**
     * The id of the publisher of the extension.
     *
     * Extensions published by Amazon aren't assigned a publisher ID. Use the `AWS_TYPES` category to specify a list of types published by Amazon.
     */
    public val publisherId: kotlin.String? = builder.publisherId
    /**
     * A prefix to use as a filter for results.
     */
    public val typeNamePrefix: kotlin.String? = builder.typeNamePrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TypeFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypeFilters(")
        append("category=$category,")
        append("publisherId=$publisherId,")
        append("typeNamePrefix=$typeNamePrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (publisherId?.hashCode() ?: 0)
        result = 31 * result + (typeNamePrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypeFilters

        if (category != other.category) return false
        if (publisherId != other.publisherId) return false
        if (typeNamePrefix != other.typeNamePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TypeFilters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The category of extensions to return.
         * + `REGISTERED`: Private extensions that have been registered for this account and region.
         * + `ACTIVATED`: Public extensions that have been activated for this account and region.
         * + `THIRD_PARTY`: Extensions available for use from publishers other than Amazon. This includes:
         *    + Private extensions registered in the account.
         *    + Public extensions from publishers other than Amazon, whether activated or not.
         * + `AWS_TYPES`: Extensions available for use from Amazon.
         */
        public var category: aws.sdk.kotlin.services.cloudformation.model.Category? = null
        /**
         * The id of the publisher of the extension.
         *
         * Extensions published by Amazon aren't assigned a publisher ID. Use the `AWS_TYPES` category to specify a list of types published by Amazon.
         */
        public var publisherId: kotlin.String? = null
        /**
         * A prefix to use as a filter for results.
         */
        public var typeNamePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TypeFilters) : this() {
            this.category = x.category
            this.publisherId = x.publisherId
            this.typeNamePrefix = x.typeNamePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TypeFilters = TypeFilters(this)
    }
}
