// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.services.cloudformation.model.CallAs
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteStackInstancesOperationSerializer: HttpSerialize<DeleteStackInstancesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DeleteStackInstancesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeDeleteStackInstancesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeDeleteStackInstancesOperationBody(context: ExecutionContext, input: DeleteStackInstancesRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Accounts"))
    val CALLAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("CallAs"))
    val DEPLOYMENTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("DeploymentTargets"))
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OperationId"))
    val OPERATIONPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("OperationPreferences"))
    val REGIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Regions"))
    val RETAINSTACKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("RetainStacks"))
    val STACKSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackSetName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("DeleteStackInstancesInput"))
        trait(QueryLiteral("Action", "DeleteStackInstances"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(ACCOUNTS_DESCRIPTOR)
        field(CALLAS_DESCRIPTOR)
        field(DEPLOYMENTTARGETS_DESCRIPTOR)
        field(OPERATIONID_DESCRIPTOR)
        field(OPERATIONPREFERENCES_DESCRIPTOR)
        field(REGIONS_DESCRIPTOR)
        field(RETAINSTACKS_DESCRIPTOR)
        field(STACKSETNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.accounts != null) {
            listField(ACCOUNTS_DESCRIPTOR) {
                for (el0 in input.accounts) {
                    serializeString(el0)
                }
            }
        }
        input.callAs?.let { field(CALLAS_DESCRIPTOR, it.value) }
        input.deploymentTargets?.let { field(DEPLOYMENTTARGETS_DESCRIPTOR, it, ::serializeDeploymentTargetsDocument) }
        input.operationId?.let { field(OPERATIONID_DESCRIPTOR, it) } ?: field(OPERATIONID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.operationPreferences?.let { field(OPERATIONPREFERENCES_DESCRIPTOR, it, ::serializeStackSetOperationPreferencesDocument) }
        if (input.regions != null) {
            listField(REGIONS_DESCRIPTOR) {
                for (el0 in input.regions) {
                    serializeString(el0)
                }
            }
        }
        field(RETAINSTACKS_DESCRIPTOR, input.retainStacks)
        input.stackSetName?.let { field(STACKSETNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
