// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetHook
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetHooksStatus
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetHooksResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeChangeSetHooksOperationDeserializer: HttpDeserialize<DescribeChangeSetHooksResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeChangeSetHooksResponse {
        if (!response.status.isSuccess()) {
            throwDescribeChangeSetHooksError(context, response)
        }
        val builder = DescribeChangeSetHooksResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeChangeSetHooksOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeChangeSetHooksError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChangeSetNotFound" -> ChangeSetNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeChangeSetHooksOperationBody(builder: DescribeChangeSetHooksResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeChangeSetHooksResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeChangeSetHooksResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeChangeSetHooks response")
    }
    // end unwrap response wrapper

    val CHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChangeSetId"))
    val CHANGESETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChangeSetName"))
    val HOOKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Hooks"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val STACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackId"))
    val STACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("DescribeChangeSetHooksResult"))
        field(CHANGESETID_DESCRIPTOR)
        field(CHANGESETNAME_DESCRIPTOR)
        field(HOOKS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STACKID_DESCRIPTOR)
        field(STACKNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGESETID_DESCRIPTOR.index -> builder.changeSetId = deserializeString()
                CHANGESETNAME_DESCRIPTOR.index -> builder.changeSetName = deserializeString()
                HOOKS_DESCRIPTOR.index -> builder.hooks =
                    deserializer.deserializeList(HOOKS_DESCRIPTOR) {
                        val col0 = mutableListOf<ChangeSetHook>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChangeSetHookDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STACKID_DESCRIPTOR.index -> builder.stackId = deserializeString()
                STACKNAME_DESCRIPTOR.index -> builder.stackName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ChangeSetHooksStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
