// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.Change
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus
import aws.sdk.kotlin.services.cloudformation.model.Parameter
import aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration
import aws.sdk.kotlin.services.cloudformation.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeChangeSetOperationDeserializer: HttpDeserialize<DescribeChangeSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeChangeSetResponse {
        if (!response.status.isSuccess()) {
            throwDescribeChangeSetError(context, response)
        }
        val builder = DescribeChangeSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeChangeSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeChangeSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChangeSetNotFound" -> ChangeSetNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeChangeSetOperationBody(builder: DescribeChangeSetResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeChangeSetResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeChangeSetResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeChangeSet response")
    }
    // end unwrap response wrapper

    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Capabilities"))
    val CHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChangeSetId"))
    val CHANGESETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChangeSetName"))
    val CHANGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Changes"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Description"))
    val EXECUTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("ExecutionStatus"))
    val INCLUDENESTEDSTACKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IncludeNestedStacks"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val NOTIFICATIONARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("NotificationARNs"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Parameters"))
    val PARENTCHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ParentChangeSetId"))
    val ROLLBACKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RollbackConfiguration"))
    val ROOTCHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("RootChangeSetId"))
    val STACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackId"))
    val STACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StatusReason"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("DescribeChangeSetResult"))
        field(CAPABILITIES_DESCRIPTOR)
        field(CHANGESETID_DESCRIPTOR)
        field(CHANGESETNAME_DESCRIPTOR)
        field(CHANGES_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXECUTIONSTATUS_DESCRIPTOR)
        field(INCLUDENESTEDSTACKS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(NOTIFICATIONARNS_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PARENTCHANGESETID_DESCRIPTOR)
        field(ROLLBACKCONFIGURATION_DESCRIPTOR)
        field(ROOTCHANGESETID_DESCRIPTOR)
        field(STACKID_DESCRIPTOR)
        field(STACKNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPABILITIES_DESCRIPTOR.index -> builder.capabilities =
                    deserializer.deserializeList(CAPABILITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Capability>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Capability.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CHANGESETID_DESCRIPTOR.index -> builder.changeSetId = deserializeString()
                CHANGESETNAME_DESCRIPTOR.index -> builder.changeSetName = deserializeString()
                CHANGES_DESCRIPTOR.index -> builder.changes =
                    deserializer.deserializeList(CHANGES_DESCRIPTOR) {
                        val col0 = mutableListOf<Change>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChangeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromIso8601(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXECUTIONSTATUS_DESCRIPTOR.index -> builder.executionStatus = deserializeString().let { ExecutionStatus.fromValue(it) }
                INCLUDENESTEDSTACKS_DESCRIPTOR.index -> builder.includeNestedStacks = deserializeBoolean()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                NOTIFICATIONARNS_DESCRIPTOR.index -> builder.notificationArNs =
                    deserializer.deserializeList(NOTIFICATIONARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARAMETERS_DESCRIPTOR.index -> builder.parameters =
                    deserializer.deserializeList(PARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Parameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARENTCHANGESETID_DESCRIPTOR.index -> builder.parentChangeSetId = deserializeString()
                ROLLBACKCONFIGURATION_DESCRIPTOR.index -> builder.rollbackConfiguration = deserializeRollbackConfigurationDocument(deserializer)
                ROOTCHANGESETID_DESCRIPTOR.index -> builder.rootChangeSetId = deserializeString()
                STACKID_DESCRIPTOR.index -> builder.stackId = deserializeString()
                STACKNAME_DESCRIPTOR.index -> builder.stackName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ChangeSetStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
