// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.waiters

import aws.sdk.kotlin.services.cloudformation.CloudFormationClient
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until change set status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilChangeSetCreateComplete(request: DescribeChangeSetRequest): Outcome<DescribeChangeSetResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeChangeSetRequest, DescribeChangeSetResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it?.status
            status?.toString() == "CREATE_COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it?.status
            status?.toString() == "FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeChangeSet(request) }
}

/**
 * Wait until change set status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilChangeSetCreateComplete(block: DescribeChangeSetRequest.Builder.() -> Unit): Outcome<DescribeChangeSetResponse> =
    waitUntilChangeSetCreateComplete(DescribeChangeSetRequest.Builder().apply(block).build())

/**
 * Wait until stack status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackCreateComplete(request: DescribeStacksRequest): Outcome<DescribeStacksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "CREATE_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "CREATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "DELETE_COMPLETE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "DELETE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "ROLLBACK_COMPLETE" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackCreateComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackCreateComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is DELETE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackDeleteComplete(request: DescribeStacksRequest): Outcome<DescribeStacksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "DELETE_COMPLETE" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ValidationError"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "DELETE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "CREATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_ROLLBACK_IN_PROGRESS" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_ROLLBACK_COMPLETE" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is DELETE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackDeleteComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackDeleteComplete(DescribeStacksRequest.Builder().apply(block).build())

public suspend fun CloudFormationClient.waitUntilStackExists(request: DescribeStacksRequest): Outcome<DescribeStacksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

public suspend fun CloudFormationClient.waitUntilStackExists(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackExists(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is IMPORT_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackImportComplete(request: DescribeStacksRequest): Outcome<DescribeStacksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "IMPORT_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "ROLLBACK_COMPLETE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "IMPORT_ROLLBACK_IN_PROGRESS" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "IMPORT_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "IMPORT_ROLLBACK_COMPLETE" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is IMPORT_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackImportComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackImportComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is UPDATE_ROLLBACK_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRollbackComplete(request: DescribeStacksRequest): Outcome<DescribeStacksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "UPDATE_ROLLBACK_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "DELETE_FAILED" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is UPDATE_ROLLBACK_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRollbackComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackRollbackComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is UPDATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackUpdateComplete(request: DescribeStacksRequest): Outcome<DescribeStacksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "UPDATE_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it?.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible() ?: listOf()
            val projection = stacksOrEmpty.flatMap {
                val stackStatus = it?.stackStatus
                listOfNotNull(stackStatus)
            }
            projection?.any { it?.toString() == "UPDATE_ROLLBACK_COMPLETE" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is UPDATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackUpdateComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackUpdateComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until type registration is COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilTypeRegistrationComplete(request: DescribeTypeRegistrationRequest): Outcome<DescribeTypeRegistrationResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeTypeRegistrationRequest, DescribeTypeRegistrationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val progressStatus = it?.progressStatus
            progressStatus?.toString() == "COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val progressStatus = it?.progressStatus
            progressStatus?.toString() == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTypeRegistration(request) }
}

/**
 * Wait until type registration is COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilTypeRegistrationComplete(block: DescribeTypeRegistrationRequest.Builder.() -> Unit): Outcome<DescribeTypeRegistrationResponse> =
    waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest.Builder().apply(block).build())
