// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the following steps.
 *
 * **To delete a web distribution using the CloudFront API:**
 * + Disable the web distribution
 * + Submit a `GET Distribution Config` request to get the current configuration and the `Etag` header for the distribution.
 * + Update the XML document that was returned in the response to your `GET Distribution Config` request to change the value of `Enabled` to `false`.
 * + Submit a `PUT Distribution Config` request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP `If-Match` header to the value of the `ETag` header that CloudFront returned when you submitted the `GET Distribution Config` request in Step 2.
 * + Review the response to the `PUT Distribution Config` request to confirm that the distribution was successfully disabled.
 * + Submit a `GET Distribution` request to confirm that your changes have propagated. When propagation is complete, the value of `Status` is `Deployed`.
 * + Submit a `DELETE Distribution` request. Set the value of the HTTP `If-Match` header to the value of the `ETag` header that CloudFront returned when you submitted the `GET Distribution Config` request in Step 6.
 * + Review the response to your `DELETE Distribution` request to confirm that the distribution was successfully deleted.
 *
 * For information about deleting a distribution using the CloudFront console, see [Deleting a Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html) in the *Amazon CloudFront Developer Guide*.
 */
public class DeleteDistributionRequest private constructor(builder: Builder) {
    /**
     * The distribution ID.
     */
    public val id: kotlin.String? = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The value of the `ETag` header that you received when you disabled the distribution. For example: `E2QWRUHAPOMQZL`.
     */
    public val ifMatch: kotlin.String? = builder.ifMatch

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.DeleteDistributionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDistributionRequest(")
        append("id=$id,")
        append("ifMatch=$ifMatch)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDistributionRequest

        if (id != other.id) return false
        if (ifMatch != other.ifMatch) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.DeleteDistributionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The distribution ID.
         */
        public var id: kotlin.String? = null
        /**
         * The value of the `ETag` header that you received when you disabled the distribution. For example: `E2QWRUHAPOMQZL`.
         */
        public var ifMatch: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.DeleteDistributionRequest) : this() {
            this.id = x.id
            this.ifMatch = x.ifMatch
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.DeleteDistributionRequest = DeleteDistributionRequest(this)
    }
}
