// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A distribution tells CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery.
 */
public class Distribution private constructor(builder: Builder) {
    /**
     * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in this distribution to serve private content using key groups. This field contains a list of key groups and the public keys in each key group that CloudFront can use to verify the signatures of signed URLs or signed cookies.
     */
    public val activeTrustedKeyGroups: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups? = builder.activeTrustedKeyGroups
    /**
     * We recommend using `TrustedKeyGroups` instead of `TrustedSigners`.
     *
     * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in this distribution to serve private content using trusted signers. This field contains a list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs or signed cookies.
     */
    public val activeTrustedSigners: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners? = builder.activeTrustedSigners
    /**
     * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
     *
     * For more information about ICP recordals, see [ Signup, Accounts, and Credentials](https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html) in *Getting Started with Amazon Web Services services in China*.
     */
    public val aliasIcpRecordals: List<AliasIcpRecordal>? = builder.aliasIcpRecordals
    /**
     * The ARN (Amazon Resource Name) for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The current configuration information for the distribution. Send a `GET` request to the `/<i>CloudFront API version</i>/distribution ID/config` resource.
     */
    public val distributionConfig: aws.sdk.kotlin.services.cloudfront.model.DistributionConfig? = builder.distributionConfig
    /**
     * The domain name corresponding to the distribution, for example, `d111111abcdef8.cloudfront.net`.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The identifier for the distribution. For example: `EDFDVBD632BHDS5`.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The number of invalidation batches currently in progress.
     */
    public val inProgressInvalidationBatches: kotlin.Int? = builder.inProgressInvalidationBatches
    /**
     * The date and time the distribution was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * This response element indicates the current status of the distribution. When the status is `Deployed`, the distribution's information is fully propagated to all CloudFront edge locations.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.Distribution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Distribution(")
        append("activeTrustedKeyGroups=$activeTrustedKeyGroups,")
        append("activeTrustedSigners=$activeTrustedSigners,")
        append("aliasIcpRecordals=$aliasIcpRecordals,")
        append("arn=$arn,")
        append("distributionConfig=$distributionConfig,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("inProgressInvalidationBatches=$inProgressInvalidationBatches,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeTrustedKeyGroups?.hashCode() ?: 0
        result = 31 * result + (activeTrustedSigners?.hashCode() ?: 0)
        result = 31 * result + (aliasIcpRecordals?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (distributionConfig?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inProgressInvalidationBatches ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Distribution

        if (activeTrustedKeyGroups != other.activeTrustedKeyGroups) return false
        if (activeTrustedSigners != other.activeTrustedSigners) return false
        if (aliasIcpRecordals != other.aliasIcpRecordals) return false
        if (arn != other.arn) return false
        if (distributionConfig != other.distributionConfig) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (inProgressInvalidationBatches != other.inProgressInvalidationBatches) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.Distribution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in this distribution to serve private content using key groups. This field contains a list of key groups and the public keys in each key group that CloudFront can use to verify the signatures of signed URLs or signed cookies.
         */
        public var activeTrustedKeyGroups: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups? = null
        /**
         * We recommend using `TrustedKeyGroups` instead of `TrustedSigners`.
         *
         * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in this distribution to serve private content using trusted signers. This field contains a list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs or signed cookies.
         */
        public var activeTrustedSigners: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners? = null
        /**
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
         *
         * For more information about ICP recordals, see [ Signup, Accounts, and Credentials](https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html) in *Getting Started with Amazon Web Services services in China*.
         */
        public var aliasIcpRecordals: List<AliasIcpRecordal>? = null
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
         */
        public var arn: kotlin.String? = null
        /**
         * The current configuration information for the distribution. Send a `GET` request to the `/<i>CloudFront API version</i>/distribution ID/config` resource.
         */
        public var distributionConfig: aws.sdk.kotlin.services.cloudfront.model.DistributionConfig? = null
        /**
         * The domain name corresponding to the distribution, for example, `d111111abcdef8.cloudfront.net`.
         */
        public var domainName: kotlin.String? = null
        /**
         * The identifier for the distribution. For example: `EDFDVBD632BHDS5`.
         */
        public var id: kotlin.String? = null
        /**
         * The number of invalidation batches currently in progress.
         */
        public var inProgressInvalidationBatches: kotlin.Int? = null
        /**
         * The date and time the distribution was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This response element indicates the current status of the distribution. When the status is `Deployed`, the distribution's information is fully propagated to all CloudFront edge locations.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.Distribution) : this() {
            this.activeTrustedKeyGroups = x.activeTrustedKeyGroups
            this.activeTrustedSigners = x.activeTrustedSigners
            this.aliasIcpRecordals = x.aliasIcpRecordals
            this.arn = x.arn
            this.distributionConfig = x.distributionConfig
            this.domainName = x.domainName
            this.id = x.id
            this.inProgressInvalidationBatches = x.inProgressInvalidationBatches
            this.lastModifiedTime = x.lastModifiedTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.Distribution = Distribution(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups] inside the given [block]
         */
        public fun activeTrustedKeyGroups(block: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups.Builder.() -> kotlin.Unit) {
            this.activeTrustedKeyGroups = aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners] inside the given [block]
         */
        public fun activeTrustedSigners(block: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners.Builder.() -> kotlin.Unit) {
            this.activeTrustedSigners = aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.DistributionConfig] inside the given [block]
         */
        public fun distributionConfig(block: aws.sdk.kotlin.services.cloudfront.model.DistributionConfig.Builder.() -> kotlin.Unit) {
            this.distributionConfig = aws.sdk.kotlin.services.cloudfront.model.DistributionConfig.invoke(block)
        }
    }
}
