// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains a Lambda@Edge function association.
 */
public class LambdaFunctionAssociation private constructor(builder: Builder) {
    /**
     * Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
     * + `viewer-request`: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
     * + `origin-request`: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
     * + `origin-response`: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
     * + `viewer-response`: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     */
    public val eventType: aws.sdk.kotlin.services.cloudfront.model.EventType? = builder.eventType
    /**
     * A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
     */
    public val includeBody: kotlin.Boolean? = builder.includeBody
    /**
     * The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
     */
    public val lambdaFunctionArn: kotlin.String? = builder.lambdaFunctionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionAssociation(")
        append("eventType=$eventType,")
        append("includeBody=$includeBody,")
        append("lambdaFunctionArn=$lambdaFunctionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventType?.hashCode() ?: 0
        result = 31 * result + (includeBody?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionAssociation

        if (eventType != other.eventType) return false
        if (includeBody != other.includeBody) return false
        if (lambdaFunctionArn != other.lambdaFunctionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
         * + `viewer-request`: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
         * + `origin-request`: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
         * + `origin-response`: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
         * + `viewer-response`: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         */
        public var eventType: aws.sdk.kotlin.services.cloudfront.model.EventType? = null
        /**
         * A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
         */
        public var includeBody: kotlin.Boolean? = null
        /**
         * The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
         */
        public var lambdaFunctionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociation) : this() {
            this.eventType = x.eventType
            this.includeBody = x.includeBody
            this.lambdaFunctionArn = x.lambdaFunctionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociation = LambdaFunctionAssociation(this)
    }
}
