// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An origin request policy.
 *
 * When it’s attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
 * + The request body and the URL path (without the domain name) from the viewer request.
 * + The headers that CloudFront automatically includes in every origin request, including `Host`, `User-Agent`, and `X-Amz-Cf-Id`.
 * + All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
 *
 * CloudFront sends a request when it can’t find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use `CachePolicy`.
 */
public class OriginRequestPolicy private constructor(builder: Builder) {
    /**
     * The unique identifier for the origin request policy.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date and time when the origin request policy was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The origin request policy configuration.
     */
    public val originRequestPolicyConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig? = builder.originRequestPolicyConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicy(")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("originRequestPolicyConfig=$originRequestPolicyConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (originRequestPolicyConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginRequestPolicy

        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (originRequestPolicyConfig != other.originRequestPolicyConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the origin request policy.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time when the origin request policy was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The origin request policy configuration.
         */
        public var originRequestPolicyConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicy) : this() {
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.originRequestPolicyConfig = x.originRequestPolicyConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicy = OriginRequestPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig] inside the given [block]
         */
        public fun originRequestPolicyConfig(block: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig.Builder.() -> kotlin.Unit) {
            this.originRequestPolicyConfig = aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig.invoke(block)
        }
    }
}
