// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An origin request policy configuration.
 *
 * This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
 * + The request body and the URL path (without the domain name) from the viewer request.
 * + The headers that CloudFront automatically includes in every origin request, including `Host`, `User-Agent`, and `X-Amz-Cf-Id`.
 * + All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
 *
 * CloudFront sends a request when it can’t find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use `CachePolicy`.
 */
public class OriginRequestPolicyConfig private constructor(builder: Builder) {
    /**
     * A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The cookies from viewer requests to include in origin requests.
     */
    public val cookiesConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig? = builder.cookiesConfig
    /**
     * The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
     */
    public val headersConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig? = builder.headersConfig
    /**
     * A unique name to identify the origin request policy.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The URL query strings from viewer requests to include in origin requests.
     */
    public val queryStringsConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig? = builder.queryStringsConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyConfig(")
        append("comment=$comment,")
        append("cookiesConfig=$cookiesConfig,")
        append("headersConfig=$headersConfig,")
        append("name=$name,")
        append("queryStringsConfig=$queryStringsConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (cookiesConfig?.hashCode() ?: 0)
        result = 31 * result + (headersConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queryStringsConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginRequestPolicyConfig

        if (comment != other.comment) return false
        if (cookiesConfig != other.cookiesConfig) return false
        if (headersConfig != other.headersConfig) return false
        if (name != other.name) return false
        if (queryStringsConfig != other.queryStringsConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A comment to describe the origin request policy. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * The cookies from viewer requests to include in origin requests.
         */
        public var cookiesConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig? = null
        /**
         * The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.
         */
        public var headersConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig? = null
        /**
         * A unique name to identify the origin request policy.
         */
        public var name: kotlin.String? = null
        /**
         * The URL query strings from viewer requests to include in origin requests.
         */
        public var queryStringsConfig: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig) : this() {
            this.comment = x.comment
            this.cookiesConfig = x.cookiesConfig
            this.headersConfig = x.headersConfig
            this.name = x.name
            this.queryStringsConfig = x.queryStringsConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig = OriginRequestPolicyConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig] inside the given [block]
         */
        public fun cookiesConfig(block: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig.Builder.() -> kotlin.Unit) {
            this.cookiesConfig = aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig] inside the given [block]
         */
        public fun headersConfig(block: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig.Builder.() -> kotlin.Unit) {
            this.headersConfig = aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig] inside the given [block]
         */
        public fun queryStringsConfig(block: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig.Builder.() -> kotlin.Unit) {
            this.queryStringsConfig = aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig.invoke(block)
        }
    }
}
