// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Determines whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header’s value.
 *
 * For more information about the `X-XSS-Protection` HTTP response header, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
 */
public class ResponseHeadersPolicyXssProtection private constructor(builder: Builder) {
    /**
     * A Boolean that determines whether CloudFront includes the `mode=block` directive in the `X-XSS-Protection` header.
     *
     * For more information about this directive, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
     */
    public val modeBlock: kotlin.Boolean? = builder.modeBlock
    /**
     * A Boolean that determines whether CloudFront overrides the `X-XSS-Protection` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    public val override: kotlin.Boolean? = builder.override
    /**
     * A Boolean that determines the value of the `X-XSS-Protection` HTTP response header. When this setting is `true`, the value of the `X-XSS-Protection` header is `1`. When this setting is `false`, the value of the `X-XSS-Protection` header is `0`.
     *
     * For more information about these settings, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
     */
    public val protection: kotlin.Boolean? = builder.protection
    /**
     * A reporting URI, which CloudFront uses as the value of the `report` directive in the `X-XSS-Protection` header.
     *
     * You cannot specify a `ReportUri` when `ModeBlock` is `true`.
     *
     * For more information about using a reporting URL, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
     */
    public val reportUri: kotlin.String? = builder.reportUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicyXssProtection(")
        append("modeBlock=$modeBlock,")
        append("override=$override,")
        append("protection=$protection,")
        append("reportUri=$reportUri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = modeBlock?.hashCode() ?: 0
        result = 31 * result + (override?.hashCode() ?: 0)
        result = 31 * result + (protection?.hashCode() ?: 0)
        result = 31 * result + (reportUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicyXssProtection

        if (modeBlock != other.modeBlock) return false
        if (override != other.override) return false
        if (protection != other.protection) return false
        if (reportUri != other.reportUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A Boolean that determines whether CloudFront includes the `mode=block` directive in the `X-XSS-Protection` header.
         *
         * For more information about this directive, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
         */
        public var modeBlock: kotlin.Boolean? = null
        /**
         * A Boolean that determines whether CloudFront overrides the `X-XSS-Protection` HTTP response header received from the origin with the one specified in this response headers policy.
         */
        public var override: kotlin.Boolean? = null
        /**
         * A Boolean that determines the value of the `X-XSS-Protection` HTTP response header. When this setting is `true`, the value of the `X-XSS-Protection` header is `1`. When this setting is `false`, the value of the `X-XSS-Protection` header is `0`.
         *
         * For more information about these settings, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
         */
        public var protection: kotlin.Boolean? = null
        /**
         * A reporting URI, which CloudFront uses as the value of the `report` directive in the `X-XSS-Protection` header.
         *
         * You cannot specify a `ReportUri` when `ModeBlock` is `true`.
         *
         * For more information about using a reporting URL, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
         */
        public var reportUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection) : this() {
            this.modeBlock = x.modeBlock
            this.override = x.override
            this.protection = x.protection
            this.reportUri = x.reportUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection = ResponseHeadersPolicyXssProtection(this)
    }
}
