// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the `CustomOriginConfig` element instead.
 */
public class S3OriginConfig private constructor(builder: Builder) {
    /**
     * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
     *
     * origin-access-identity/cloudfront&#47;*ID-of-origin-access-identity*
     *
     * where ` <i>ID-of-origin-access-identity</i> ` is the value that CloudFront returned in the `ID` element when you created the origin access identity.
     *
     * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty `OriginAccessIdentity` element.
     *
     * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty `OriginAccessIdentity` element.
     *
     * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
     *
     * For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val originAccessIdentity: kotlin.String? = builder.originAccessIdentity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3OriginConfig(")
        append("originAccessIdentity=$originAccessIdentity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = originAccessIdentity?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3OriginConfig

        if (originAccessIdentity != other.originAccessIdentity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
         *
         * origin-access-identity/cloudfront&#47;*ID-of-origin-access-identity*
         *
         * where ` <i>ID-of-origin-access-identity</i> ` is the value that CloudFront returned in the `ID` element when you created the origin access identity.
         *
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty `OriginAccessIdentity` element.
         *
         * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty `OriginAccessIdentity` element.
         *
         * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         *
         * For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var originAccessIdentity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig) : this() {
            this.originAccessIdentity = x.originAccessIdentity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig = S3OriginConfig(this)
    }
}
