// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



public class UpdateFunctionRequest private constructor(builder: Builder) {
    /**
     * The function code. For more information about writing a CloudFront function, see [Writing function code for CloudFront Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val functionCode: kotlin.ByteArray? = builder.functionCode
    /**
     * Configuration information about the function.
     */
    public val functionConfig: aws.sdk.kotlin.services.cloudfront.model.FunctionConfig? = builder.functionConfig
    /**
     * The current version (`ETag` value) of the function that you are updating, which you can get using `DescribeFunction`.
     */
    public val ifMatch: kotlin.String? = builder.ifMatch
    /**
     * The name of the function that you are updating.
     */
    public val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.UpdateFunctionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionRequest(")
        append("functionCode=*** Sensitive Data Redacted ***,")
        append("functionConfig=$functionConfig,")
        append("ifMatch=$ifMatch,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionCode?.contentHashCode() ?: 0
        result = 31 * result + (functionConfig?.hashCode() ?: 0)
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFunctionRequest

        if (functionCode != null) {
            if (other.functionCode == null) return false
            if (!functionCode.contentEquals(other.functionCode)) return false
        } else if (other.functionCode != null) return false
        if (functionConfig != other.functionConfig) return false
        if (ifMatch != other.ifMatch) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.UpdateFunctionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The function code. For more information about writing a CloudFront function, see [Writing function code for CloudFront Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var functionCode: kotlin.ByteArray? = null
        /**
         * Configuration information about the function.
         */
        public var functionConfig: aws.sdk.kotlin.services.cloudfront.model.FunctionConfig? = null
        /**
         * The current version (`ETag` value) of the function that you are updating, which you can get using `DescribeFunction`.
         */
        public var ifMatch: kotlin.String? = null
        /**
         * The name of the function that you are updating.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.UpdateFunctionRequest) : this() {
            this.functionCode = x.functionCode
            this.functionConfig = x.functionConfig
            this.ifMatch = x.ifMatch
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.UpdateFunctionRequest = UpdateFunctionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionConfig] inside the given [block]
         */
        public fun functionConfig(block: aws.sdk.kotlin.services.cloudfront.model.FunctionConfig.Builder.() -> kotlin.Unit) {
            this.functionConfig = aws.sdk.kotlin.services.cloudfront.model.FunctionConfig.invoke(block)
        }
    }
}
