// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.GetKeyGroupResponse
import aws.sdk.kotlin.services.cloudfront.model.KeyGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class GetKeyGroupOperationDeserializer: HttpDeserialize<GetKeyGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetKeyGroupResponse {
        if (!response.status.isSuccess()) {
            throwGetKeyGroupError(context, response)
        }
        val builder = GetKeyGroupResponse.Builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.keyGroup = deserializeKeyGroupPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwGetKeyGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchResource" -> NoSuchResourceDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
