// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.GetRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetRealtimeLogConfigOperationDeserializer: HttpDeserialize<GetRealtimeLogConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRealtimeLogConfigResponse {
        if (!response.status.isSuccess()) {
            throwGetRealtimeLogConfigError(context, response)
        }
        val builder = GetRealtimeLogConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRealtimeLogConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRealtimeLogConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "NoSuchRealtimeLogConfig" -> NoSuchRealtimeLogConfigDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRealtimeLogConfigOperationBody(builder: GetRealtimeLogConfigResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val REALTIMELOGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RealtimeLogConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetRealtimeLogConfigResult"))
        trait(XmlNamespace("http://cloudfront.amazonaws.com/doc/2020-05-31/"))
        field(REALTIMELOGCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REALTIMELOGCONFIG_DESCRIPTOR.index -> builder.realtimeLogConfig = deserializeRealtimeLogConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
