// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
 * + CloudFront forwards only `GET` and `HEAD` requests.
 * + CloudFront forwards only `GET`, `HEAD`, and `OPTIONS` requests.
 * + CloudFront forwards `GET, HEAD, OPTIONS, PUT, PATCH, POST`, and `DELETE` requests.
 *
 * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
 */
public class AllowedMethods private constructor(builder: Builder) {
    /**
     * A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
     * + CloudFront caches responses to `GET` and `HEAD` requests.
     * + CloudFront caches responses to `GET`, `HEAD`, and `OPTIONS` requests.
     *
     * If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
     */
    public val cachedMethods: aws.sdk.kotlin.services.cloudfront.model.CachedMethods? = builder.cachedMethods
    /**
     * A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.
     */
    public val items: List<Method>? = builder.items
    /**
     * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for `GET` and `HEAD` requests), 3 (for `GET`, `HEAD`, and `OPTIONS` requests) and 7 (for `GET, HEAD, OPTIONS, PUT, PATCH, POST`, and `DELETE` requests).
     */
    public val quantity: kotlin.Int? = builder.quantity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.AllowedMethods = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AllowedMethods(")
        append("cachedMethods=$cachedMethods,")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cachedMethods?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AllowedMethods

        if (cachedMethods != other.cachedMethods) return false
        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.AllowedMethods = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
         * + CloudFront caches responses to `GET` and `HEAD` requests.
         * + CloudFront caches responses to `GET`, `HEAD`, and `OPTIONS` requests.
         *
         * If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
         */
        public var cachedMethods: aws.sdk.kotlin.services.cloudfront.model.CachedMethods? = null
        /**
         * A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.
         */
        public var items: List<Method>? = null
        /**
         * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for `GET` and `HEAD` requests), 3 (for `GET`, `HEAD`, and `OPTIONS` requests) and 7 (for `GET, HEAD, OPTIONS, PUT, PATCH, POST`, and `DELETE` requests).
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.AllowedMethods) : this() {
            this.cachedMethods = x.cachedMethods
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.AllowedMethods = AllowedMethods(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachedMethods] inside the given [block]
         */
        public fun cachedMethods(block: aws.sdk.kotlin.services.cloudfront.model.CachedMethods.Builder.() -> kotlin.Unit) {
            this.cachedMethods = aws.sdk.kotlin.services.cloudfront.model.CachedMethods.invoke(block)
        }
    }
}
