// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 */
public class CachePolicyCookiesConfig private constructor(builder: Builder) {
    /**
     * Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are:
     * + `none` – Cookies in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any cookies that are listed in an `OriginRequestPolicy`*are* included in origin requests.
     * + `whitelist` – The cookies in viewer requests that are listed in the `CookieNames` type are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * + `allExcept` – All cookies in viewer requests that are ***not*** listed in the `CookieNames` type are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * + `all` – All cookies in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     */
    public val cookieBehavior: aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookieBehavior? = builder.cookieBehavior
    /**
     * Contains a list of cookie names.
     */
    public val cookies: aws.sdk.kotlin.services.cloudfront.model.CookieNames? = builder.cookies

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyCookiesConfig(")
        append("cookieBehavior=$cookieBehavior,")
        append("cookies=$cookies)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookieBehavior?.hashCode() ?: 0
        result = 31 * result + (cookies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachePolicyCookiesConfig

        if (cookieBehavior != other.cookieBehavior) return false
        if (cookies != other.cookies) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are:
         * + `none` – Cookies in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any cookies that are listed in an `OriginRequestPolicy`*are* included in origin requests.
         * + `whitelist` – The cookies in viewer requests that are listed in the `CookieNames` type are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         * + `allExcept` – All cookies in viewer requests that are ***not*** listed in the `CookieNames` type are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         * + `all` – All cookies in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
         */
        public var cookieBehavior: aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookieBehavior? = null
        /**
         * Contains a list of cookie names.
         */
        public var cookies: aws.sdk.kotlin.services.cloudfront.model.CookieNames? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig) : this() {
            this.cookieBehavior = x.cookieBehavior
            this.cookies = x.cookies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig = CachePolicyCookiesConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CookieNames] inside the given [block]
         */
        public fun cookies(block: aws.sdk.kotlin.services.cloudfront.model.CookieNames.Builder.() -> kotlin.Unit) {
            this.cookies = aws.sdk.kotlin.services.cloudfront.model.CookieNames.invoke(block)
        }
    }
}
