// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)*is* a custom origin.
 */
public class CustomOriginConfig private constructor(builder: Builder) {
    /**
     * The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
     */
    public val httpPort: kotlin.Int? = builder.httpPort
    /**
     * The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
     */
    public val httpsPort: kotlin.Int? = builder.httpsPort
    /**
     * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is 5 seconds.
     *
     * For more information, see [Origin Keep-alive Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
     */
    public val originKeepaliveTimeout: kotlin.Int? = builder.originKeepaliveTimeout
    /**
     * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
     * + `http-only` – CloudFront always uses HTTP to connect to the origin.
     * + `match-viewer` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
     * + `https-only` – CloudFront always uses HTTPS to connect to the origin.
     */
    public val originProtocolPolicy: aws.sdk.kotlin.services.cloudfront.model.OriginProtocolPolicy? = builder.originProtocolPolicy
    /**
     * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is 30 seconds.
     *
     * For more information, see [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
     */
    public val originReadTimeout: kotlin.Int? = builder.originReadTimeout
    /**
     * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     *
     * For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
     */
    public val originSslProtocols: aws.sdk.kotlin.services.cloudfront.model.OriginSslProtocols? = builder.originSslProtocols

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomOriginConfig(")
        append("httpPort=$httpPort,")
        append("httpsPort=$httpsPort,")
        append("originKeepaliveTimeout=$originKeepaliveTimeout,")
        append("originProtocolPolicy=$originProtocolPolicy,")
        append("originReadTimeout=$originReadTimeout,")
        append("originSslProtocols=$originSslProtocols)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpPort ?: 0
        result = 31 * result + (httpsPort ?: 0)
        result = 31 * result + (originKeepaliveTimeout ?: 0)
        result = 31 * result + (originProtocolPolicy?.hashCode() ?: 0)
        result = 31 * result + (originReadTimeout ?: 0)
        result = 31 * result + (originSslProtocols?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomOriginConfig

        if (httpPort != other.httpPort) return false
        if (httpsPort != other.httpsPort) return false
        if (originKeepaliveTimeout != other.originKeepaliveTimeout) return false
        if (originProtocolPolicy != other.originProtocolPolicy) return false
        if (originReadTimeout != other.originReadTimeout) return false
        if (originSslProtocols != other.originSslProtocols) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
         */
        public var httpPort: kotlin.Int? = null
        /**
         * The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
         */
        public var httpsPort: kotlin.Int? = null
        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is 5 seconds.
         *
         * For more information, see [Origin Keep-alive Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
         */
        public var originKeepaliveTimeout: kotlin.Int? = null
        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
         * + `http-only` – CloudFront always uses HTTP to connect to the origin.
         * + `match-viewer` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
         * + `https-only` – CloudFront always uses HTTPS to connect to the origin.
         */
        public var originProtocolPolicy: aws.sdk.kotlin.services.cloudfront.model.OriginProtocolPolicy? = null
        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is 30 seconds.
         *
         * For more information, see [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
         */
        public var originReadTimeout: kotlin.Int? = null
        /**
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
         *
         * For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
         */
        public var originSslProtocols: aws.sdk.kotlin.services.cloudfront.model.OriginSslProtocols? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig) : this() {
            this.httpPort = x.httpPort
            this.httpsPort = x.httpsPort
            this.originKeepaliveTimeout = x.originKeepaliveTimeout
            this.originProtocolPolicy = x.originProtocolPolicy
            this.originReadTimeout = x.originReadTimeout
            this.originSslProtocols = x.originSslProtocols
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig = CustomOriginConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginSslProtocols] inside the given [block]
         */
        public fun originSslProtocols(block: aws.sdk.kotlin.services.cloudfront.model.OriginSslProtocols.Builder.() -> kotlin.Unit) {
            this.originSslProtocols = aws.sdk.kotlin.services.cloudfront.model.OriginSslProtocols.invoke(block)
        }
    }
}
