// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * This object determines the values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
 *
 * The headers, cookies, and query strings that are included in the cache key are automatically included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that matches the request’s cache key. If you want to send values to the origin but *not* include them in the cache key, use `OriginRequestPolicy`.
 */
public class ParametersInCacheKeyAndForwardedToOrigin private constructor(builder: Builder) {
    /**
     * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     */
    public val cookiesConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig? = builder.cookiesConfig
    /**
     * A flag that can affect whether the `Accept-Encoding` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
     *
     * This field is related to the `EnableAcceptEncodingGzip` field. If one or both of these fields is `true`*and* the viewer request includes the `Accept-Encoding` header, then CloudFront does the following:
     * + Normalizes the value of the viewer’s `Accept-Encoding` header
     * + Includes the normalized header in the cache key
     * + Includes the normalized header in the request to the origin, if a request is necessary
     *
     * For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
     *
     * If you set this value to `true`, and this cache behavior also has an origin request policy attached, do not include the `Accept-Encoding` header in the origin request policy. CloudFront always includes the `Accept-Encoding` header in origin requests when the value of this field is `true`, so including this header in an origin request policy has no effect.
     *
     * If both of these fields are `false`, then CloudFront treats the `Accept-Encoding` header the same as any other HTTP header in the viewer request. By default, it’s not included in the cache key and it’s not included in origin requests. In this case, you can manually add `Accept-Encoding` to the headers whitelist like any other HTTP header.
     */
    public val enableAcceptEncodingBrotli: kotlin.Boolean? = builder.enableAcceptEncodingBrotli
    /**
     * A flag that can affect whether the `Accept-Encoding` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
     *
     * This field is related to the `EnableAcceptEncodingBrotli` field. If one or both of these fields is `true`*and* the viewer request includes the `Accept-Encoding` header, then CloudFront does the following:
     * + Normalizes the value of the viewer’s `Accept-Encoding` header
     * + Includes the normalized header in the cache key
     * + Includes the normalized header in the request to the origin, if a request is necessary
     *
     * For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
     *
     * If you set this value to `true`, and this cache behavior also has an origin request policy attached, do not include the `Accept-Encoding` header in the origin request policy. CloudFront always includes the `Accept-Encoding` header in origin requests when the value of this field is `true`, so including this header in an origin request policy has no effect.
     *
     * If both of these fields are `false`, then CloudFront treats the `Accept-Encoding` header the same as any other HTTP header in the viewer request. By default, it’s not included in the cache key and it’s not included in origin requests. In this case, you can manually add `Accept-Encoding` to the headers whitelist like any other HTTP header.
     */
    public val enableAcceptEncodingGzip: kotlin.Boolean? = builder.enableAcceptEncodingGzip
    /**
     * An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     */
    public val headersConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig? = builder.headersConfig
    /**
     * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     */
    public val queryStringsConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig? = builder.queryStringsConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParametersInCacheKeyAndForwardedToOrigin(")
        append("cookiesConfig=$cookiesConfig,")
        append("enableAcceptEncodingBrotli=$enableAcceptEncodingBrotli,")
        append("enableAcceptEncodingGzip=$enableAcceptEncodingGzip,")
        append("headersConfig=$headersConfig,")
        append("queryStringsConfig=$queryStringsConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookiesConfig?.hashCode() ?: 0
        result = 31 * result + (enableAcceptEncodingBrotli?.hashCode() ?: 0)
        result = 31 * result + (enableAcceptEncodingGzip?.hashCode() ?: 0)
        result = 31 * result + (headersConfig?.hashCode() ?: 0)
        result = 31 * result + (queryStringsConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParametersInCacheKeyAndForwardedToOrigin

        if (cookiesConfig != other.cookiesConfig) return false
        if (enableAcceptEncodingBrotli != other.enableAcceptEncodingBrotli) return false
        if (enableAcceptEncodingGzip != other.enableAcceptEncodingGzip) return false
        if (headersConfig != other.headersConfig) return false
        if (queryStringsConfig != other.queryStringsConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         */
        public var cookiesConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig? = null
        /**
         * A flag that can affect whether the `Accept-Encoding` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         *
         * This field is related to the `EnableAcceptEncodingGzip` field. If one or both of these fields is `true`*and* the viewer request includes the `Accept-Encoding` header, then CloudFront does the following:
         * + Normalizes the value of the viewer’s `Accept-Encoding` header
         * + Includes the normalized header in the cache key
         * + Includes the normalized header in the request to the origin, if a request is necessary
         *
         * For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         *
         * If you set this value to `true`, and this cache behavior also has an origin request policy attached, do not include the `Accept-Encoding` header in the origin request policy. CloudFront always includes the `Accept-Encoding` header in origin requests when the value of this field is `true`, so including this header in an origin request policy has no effect.
         *
         * If both of these fields are `false`, then CloudFront treats the `Accept-Encoding` header the same as any other HTTP header in the viewer request. By default, it’s not included in the cache key and it’s not included in origin requests. In this case, you can manually add `Accept-Encoding` to the headers whitelist like any other HTTP header.
         */
        public var enableAcceptEncodingBrotli: kotlin.Boolean? = null
        /**
         * A flag that can affect whether the `Accept-Encoding` HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         *
         * This field is related to the `EnableAcceptEncodingBrotli` field. If one or both of these fields is `true`*and* the viewer request includes the `Accept-Encoding` header, then CloudFront does the following:
         * + Normalizes the value of the viewer’s `Accept-Encoding` header
         * + Includes the normalized header in the cache key
         * + Includes the normalized header in the request to the origin, if a request is necessary
         *
         * For more information, see [Compression support](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects) in the *Amazon CloudFront Developer Guide*.
         *
         * If you set this value to `true`, and this cache behavior also has an origin request policy attached, do not include the `Accept-Encoding` header in the origin request policy. CloudFront always includes the `Accept-Encoding` header in origin requests when the value of this field is `true`, so including this header in an origin request policy has no effect.
         *
         * If both of these fields are `false`, then CloudFront treats the `Accept-Encoding` header the same as any other HTTP header in the viewer request. By default, it’s not included in the cache key and it’s not included in origin requests. In this case, you can manually add `Accept-Encoding` to the headers whitelist like any other HTTP header.
         */
        public var enableAcceptEncodingGzip: kotlin.Boolean? = null
        /**
         * An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         */
        public var headersConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig? = null
        /**
         * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         */
        public var queryStringsConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin) : this() {
            this.cookiesConfig = x.cookiesConfig
            this.enableAcceptEncodingBrotli = x.enableAcceptEncodingBrotli
            this.enableAcceptEncodingGzip = x.enableAcceptEncodingGzip
            this.headersConfig = x.headersConfig
            this.queryStringsConfig = x.queryStringsConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin = ParametersInCacheKeyAndForwardedToOrigin(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig] inside the given [block]
         */
        public fun cookiesConfig(block: aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig.Builder.() -> kotlin.Unit) {
            this.cookiesConfig = aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig] inside the given [block]
         */
        public fun headersConfig(block: aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig.Builder.() -> kotlin.Unit) {
            this.headersConfig = aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig] inside the given [block]
         */
        public fun queryStringsConfig(block: aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig.Builder.() -> kotlin.Unit) {
            this.queryStringsConfig = aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig.invoke(block)
        }
    }
}
