// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of Amazon Web Services accounts and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.
 */
public class Signer private constructor(builder: Builder) {
    /**
     * An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs is the same account that owns the CloudFront distribution, the value of this field is `self`.
     */
    public val awsAccountNumber: kotlin.String? = builder.awsAccountNumber
    /**
     * A list of CloudFront key pair identifiers.
     */
    public val keyPairIds: aws.sdk.kotlin.services.cloudfront.model.KeyPairIds? = builder.keyPairIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.Signer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Signer(")
        append("awsAccountNumber=$awsAccountNumber,")
        append("keyPairIds=$keyPairIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountNumber?.hashCode() ?: 0
        result = 31 * result + (keyPairIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Signer

        if (awsAccountNumber != other.awsAccountNumber) return false
        if (keyPairIds != other.keyPairIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.Signer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs is the same account that owns the CloudFront distribution, the value of this field is `self`.
         */
        public var awsAccountNumber: kotlin.String? = null
        /**
         * A list of CloudFront key pair identifiers.
         */
        public var keyPairIds: aws.sdk.kotlin.services.cloudfront.model.KeyPairIds? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.Signer) : this() {
            this.awsAccountNumber = x.awsAccountNumber
            this.keyPairIds = x.keyPairIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.Signer = Signer(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.KeyPairIds] inside the given [block]
         */
        public fun keyPairIds(block: aws.sdk.kotlin.services.cloudfront.model.KeyPairIds.Builder.() -> kotlin.Unit) {
            this.keyPairIds = aws.sdk.kotlin.services.cloudfront.model.KeyPairIds.invoke(block)
        }
    }
}
