// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that determines the distribution’s SSL/TLS configuration for communicating with viewers.
 *
 * If the distribution doesn’t use `Aliases` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net`—set `CloudFrontDefaultCertificate` to `true` and leave all other fields empty.
 *
 * If the distribution uses `Aliases` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
 * + Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don’t support SNI.
 *    + To accept HTTPS connections from only viewers that support SNI, set `SSLSupportMethod` to `sni-only`. This is recommended. Most browsers and clients support SNI.
 *    + To accept HTTPS connections from all viewers, including those that don’t support SNI, set `SSLSupportMethod` to `vip`. This is not recommended, and results in additional monthly charges from CloudFront.
 * + The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for `MinimumProtocolVersion`. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
 * + The location of the SSL/TLS certificate, [Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [Identity and Access Management (IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
 *    + `ACMCertificateArn`
 *    + `IAMCertificateId`
 *
 * All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use `ViewerProtocolPolicy` in the `CacheBehavior` or `DefaultCacheBehavior`. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use `CustomOriginConfig`.
 *
 * For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [ Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
 */
public class ViewerCertificate private constructor(builder: Builder) {
    /**
     * If the distribution uses `Aliases` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (`us-east-1`).
     *
     * If you specify an ACM certificate ARN, you must also specify values for `MinimumProtocolVersion` and `SSLSupportMethod`.
     */
    public val acmCertificateArn: kotlin.String? = builder.acmCertificateArn
    /**
     * This field is deprecated. Use one of the following fields instead:
     * + `ACMCertificateArn`
     * + `IAMCertificateId`
     * + `CloudFrontDefaultCertificate`
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val certificate: kotlin.String? = builder.certificate
    /**
     * This field is deprecated. Use one of the following fields instead:
     * + `ACMCertificateArn`
     * + `IAMCertificateId`
     * + `CloudFrontDefaultCertificate`
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val certificateSource: aws.sdk.kotlin.services.cloudfront.model.CertificateSource? = builder.certificateSource
    /**
     * If the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net`, set this field to `true`.
     *
     * If the distribution uses `Aliases` (alternate domain names or CNAMEs), set this field to `false` and specify values for the following fields:
     * + `ACMCertificateArn` or `IAMCertificateId` (specify a value for one, not both)
     * + `MinimumProtocolVersion`
     * + `SSLSupportMethod`
     */
    public val cloudFrontDefaultCertificate: kotlin.Boolean? = builder.cloudFrontDefaultCertificate
    /**
     * If the distribution uses `Aliases` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [Identity and Access Management (IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
     *
     * If you specify an IAM certificate ID, you must also specify values for `MinimumProtocolVersion` and `SSLSupportMethod`.
     */
    public val iamCertificateId: kotlin.String? = builder.iamCertificateId
    /**
     * If the distribution uses `Aliases` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
     * + The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
     * + The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
     *
     * For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
     *
     * On the CloudFront console, this setting is called **Security Policy**.
     *
     * When you’re using SNI only (you set `SSLSupportMethod` to `sni-only`), you must specify `TLSv1` or higher.
     *
     * If the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net` (you set `CloudFrontDefaultCertificate` to `true`), CloudFront automatically sets the security policy to `TLSv1` regardless of the value that you set here.
     */
    public val minimumProtocolVersion: aws.sdk.kotlin.services.cloudfront.model.MinimumProtocolVersion? = builder.minimumProtocolVersion
    /**
     * If the distribution uses `Aliases` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
     * + `sni-only` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
     * + `vip` – The distribution accepts HTTPS connections from all viewers including those that don’t support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
     * + `static-ip` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/home).
     *
     * If the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net`, don’t set a value for this field.
     */
    public val sslSupportMethod: aws.sdk.kotlin.services.cloudfront.model.SslSupportMethod? = builder.sslSupportMethod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ViewerCertificate(")
        append("acmCertificateArn=$acmCertificateArn,")
        append("certificate=$certificate,")
        append("certificateSource=$certificateSource,")
        append("cloudFrontDefaultCertificate=$cloudFrontDefaultCertificate,")
        append("iamCertificateId=$iamCertificateId,")
        append("minimumProtocolVersion=$minimumProtocolVersion,")
        append("sslSupportMethod=$sslSupportMethod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acmCertificateArn?.hashCode() ?: 0
        result = 31 * result + (certificate?.hashCode() ?: 0)
        result = 31 * result + (certificateSource?.hashCode() ?: 0)
        result = 31 * result + (cloudFrontDefaultCertificate?.hashCode() ?: 0)
        result = 31 * result + (iamCertificateId?.hashCode() ?: 0)
        result = 31 * result + (minimumProtocolVersion?.hashCode() ?: 0)
        result = 31 * result + (sslSupportMethod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ViewerCertificate

        if (acmCertificateArn != other.acmCertificateArn) return false
        if (certificate != other.certificate) return false
        if (certificateSource != other.certificateSource) return false
        if (cloudFrontDefaultCertificate != other.cloudFrontDefaultCertificate) return false
        if (iamCertificateId != other.iamCertificateId) return false
        if (minimumProtocolVersion != other.minimumProtocolVersion) return false
        if (sslSupportMethod != other.sslSupportMethod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the distribution uses `Aliases` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (`us-east-1`).
         *
         * If you specify an ACM certificate ARN, you must also specify values for `MinimumProtocolVersion` and `SSLSupportMethod`.
         */
        public var acmCertificateArn: kotlin.String? = null
        /**
         * This field is deprecated. Use one of the following fields instead:
         * + `ACMCertificateArn`
         * + `IAMCertificateId`
         * + `CloudFrontDefaultCertificate`
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var certificate: kotlin.String? = null
        /**
         * This field is deprecated. Use one of the following fields instead:
         * + `ACMCertificateArn`
         * + `IAMCertificateId`
         * + `CloudFrontDefaultCertificate`
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var certificateSource: aws.sdk.kotlin.services.cloudfront.model.CertificateSource? = null
        /**
         * If the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net`, set this field to `true`.
         *
         * If the distribution uses `Aliases` (alternate domain names or CNAMEs), set this field to `false` and specify values for the following fields:
         * + `ACMCertificateArn` or `IAMCertificateId` (specify a value for one, not both)
         * + `MinimumProtocolVersion`
         * + `SSLSupportMethod`
         */
        public var cloudFrontDefaultCertificate: kotlin.Boolean? = null
        /**
         * If the distribution uses `Aliases` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [Identity and Access Management (IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
         *
         * If you specify an IAM certificate ID, you must also specify values for `MinimumProtocolVersion` and `SSLSupportMethod`.
         */
        public var iamCertificateId: kotlin.String? = null
        /**
         * If the distribution uses `Aliases` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
         * + The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
         * + The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
         *
         * For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
         *
         * On the CloudFront console, this setting is called **Security Policy**.
         *
         * When you’re using SNI only (you set `SSLSupportMethod` to `sni-only`), you must specify `TLSv1` or higher.
         *
         * If the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net` (you set `CloudFrontDefaultCertificate` to `true`), CloudFront automatically sets the security policy to `TLSv1` regardless of the value that you set here.
         */
        public var minimumProtocolVersion: aws.sdk.kotlin.services.cloudfront.model.MinimumProtocolVersion? = null
        /**
         * If the distribution uses `Aliases` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
         * + `sni-only` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
         * + `vip` – The distribution accepts HTTPS connections from all viewers including those that don’t support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
         * + `static-ip` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/home).
         *
         * If the distribution uses the CloudFront domain name such as `d111111abcdef8.cloudfront.net`, don’t set a value for this field.
         */
        public var sslSupportMethod: aws.sdk.kotlin.services.cloudfront.model.SslSupportMethod? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate) : this() {
            this.acmCertificateArn = x.acmCertificateArn
            this.certificate = x.certificate
            this.certificateSource = x.certificateSource
            this.cloudFrontDefaultCertificate = x.cloudFrontDefaultCertificate
            this.iamCertificateId = x.iamCertificateId
            this.minimumProtocolVersion = x.minimumProtocolVersion
            this.sslSupportMethod = x.sslSupportMethod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate = ViewerCertificate(this)
    }
}
