// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
import aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryptionProfile
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class CreateFieldLevelEncryptionProfileOperationDeserializer: HttpDeserialize<CreateFieldLevelEncryptionProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateFieldLevelEncryptionProfileResponse {
        if (!response.status.isSuccess()) {
            throwCreateFieldLevelEncryptionProfileError(context, response)
        }
        val builder = CreateFieldLevelEncryptionProfileResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.fieldLevelEncryptionProfile = deserializeFieldLevelEncryptionProfilePayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwCreateFieldLevelEncryptionProfileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FieldLevelEncryptionProfileAlreadyExists" -> FieldLevelEncryptionProfileAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "FieldLevelEncryptionProfileSizeExceeded" -> FieldLevelEncryptionProfileSizeExceededDeserializer().deserialize(context, wrappedResponse)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "NoSuchPublicKey" -> NoSuchPublicKeyDeserializer().deserialize(context, wrappedResponse)
        "TooManyFieldLevelEncryptionEncryptionEntities" -> TooManyFieldLevelEncryptionEncryptionEntitiesDeserializer().deserialize(context, wrappedResponse)
        "TooManyFieldLevelEncryptionFieldPatterns" -> TooManyFieldLevelEncryptionFieldPatternsDeserializer().deserialize(context, wrappedResponse)
        "TooManyFieldLevelEncryptionProfiles" -> TooManyFieldLevelEncryptionProfilesDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
