// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse
import aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class CreateStreamingDistributionWithTagsOperationDeserializer: HttpDeserialize<CreateStreamingDistributionWithTagsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateStreamingDistributionWithTagsResponse {
        if (!response.status.isSuccess()) {
            throwCreateStreamingDistributionWithTagsError(context, response)
        }
        val builder = CreateStreamingDistributionWithTagsResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.streamingDistribution = deserializeStreamingDistributionPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwCreateStreamingDistributionWithTagsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidOrigin" -> InvalidOriginDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagging" -> InvalidTaggingDeserializer().deserialize(context, wrappedResponse)
        "MissingBody" -> MissingBodyDeserializer().deserialize(context, wrappedResponse)
        "StreamingDistributionAlreadyExists" -> StreamingDistributionAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "TooManyStreamingDistributionCNAMEs" -> TooManyStreamingDistributionCnamEsDeserializer().deserialize(context, wrappedResponse)
        "TooManyStreamingDistributions" -> TooManyStreamingDistributionsDeserializer().deserialize(context, wrappedResponse)
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer().deserialize(context, wrappedResponse)
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
