// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.DeleteResponseHeadersPolicyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteResponseHeadersPolicyOperationDeserializer: HttpDeserialize<DeleteResponseHeadersPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteResponseHeadersPolicyResponse {
        if (!response.status.isSuccess()) {
            throwDeleteResponseHeadersPolicyError(context, response)
        }
        val builder = DeleteResponseHeadersPolicyResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteResponseHeadersPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "IllegalDelete" -> IllegalDeleteDeserializer().deserialize(context, wrappedResponse)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchResponseHeadersPolicy" -> NoSuchResponseHeadersPolicyDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedResponse)
        "ResponseHeadersPolicyInUse" -> ResponseHeadersPolicyInUseDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
