// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.DistributionIdList
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByKeyGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class ListDistributionsByKeyGroupOperationDeserializer: HttpDeserialize<ListDistributionsByKeyGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDistributionsByKeyGroupResponse {
        if (!response.status.isSuccess()) {
            throwListDistributionsByKeyGroupError(context, response)
        }
        val builder = ListDistributionsByKeyGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.distributionIdList = deserializeDistributionIdListPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwListDistributionsByKeyGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "NoSuchResource" -> NoSuchResourceDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
