// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.waiters

import aws.sdk.kotlin.services.cloudfront.CloudFrontClient
import aws.sdk.kotlin.services.cloudfront.model.GetDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.GetInvalidationRequest
import aws.sdk.kotlin.services.cloudfront.model.GetInvalidationResponse
import aws.sdk.kotlin.services.cloudfront.model.GetStreamingDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetStreamingDistributionResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a distribution is deployed.
 */
public suspend fun CloudFrontClient.waitUntilDistributionDeployed(request: GetDistributionRequest): Outcome<GetDistributionResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetDistributionRequest, GetDistributionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val distribution = it?.distribution
            val status = distribution?.status
            status?.toString() == "Deployed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getDistribution(request) }
}

/**
 * Wait until a distribution is deployed.
 */
public suspend fun CloudFrontClient.waitUntilDistributionDeployed(block: GetDistributionRequest.Builder.() -> Unit): Outcome<GetDistributionResponse> =
    waitUntilDistributionDeployed(GetDistributionRequest.Builder().apply(block).build())

/**
 * Wait until an invalidation has completed.
 */
public suspend fun CloudFrontClient.waitUntilInvalidationCompleted(request: GetInvalidationRequest): Outcome<GetInvalidationResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 20_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetInvalidationRequest, GetInvalidationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val invalidation = it?.invalidation
            val status = invalidation?.status
            status?.toString() == "Completed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getInvalidation(request) }
}

/**
 * Wait until an invalidation has completed.
 */
public suspend fun CloudFrontClient.waitUntilInvalidationCompleted(block: GetInvalidationRequest.Builder.() -> Unit): Outcome<GetInvalidationResponse> =
    waitUntilInvalidationCompleted(GetInvalidationRequest.Builder().apply(block).build())

/**
 * Wait until a streaming distribution is deployed.
 */
public suspend fun CloudFrontClient.waitUntilStreamingDistributionDeployed(request: GetStreamingDistributionRequest): Outcome<GetStreamingDistributionResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetStreamingDistributionRequest, GetStreamingDistributionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val streamingDistribution = it?.streamingDistribution
            val status = streamingDistribution?.status
            status?.toString() == "Deployed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getStreamingDistribution(request) }
}

/**
 * Wait until a streaming distribution is deployed.
 */
public suspend fun CloudFrontClient.waitUntilStreamingDistributionDeployed(block: GetStreamingDistributionRequest.Builder.() -> Unit): Outcome<GetStreamingDistributionResponse> =
    waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest.Builder().apply(block).build())
