// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.model



/**
 * Contains the inputs for the `CreateHsm` operation.
 */
class CreateHsmRequest private constructor(builder: Builder) {
    /**
     * A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The IP address to assign to the HSM's ENI.
     *
     * If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.
     */
    val eniIp: kotlin.String? = builder.eniIp
    /**
     * The external ID from `IamRoleArn`, if present.
     */
    val externalId: kotlin.String? = builder.externalId
    /**
     * The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The SSH public key to install on the HSM.
     */
    val sshKey: kotlin.String? = builder.sshKey
    /**
     * The identifier of the subnet in your VPC in which to place the HSM.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * Specifies the type of subscription for the HSM.
     * + **PRODUCTION** - The HSM is being used in a production environment.
     * + **TRIAL** - The HSM is being used in a product trial.
     */
    val subscriptionType: aws.sdk.kotlin.services.cloudhsm.model.SubscriptionType? = builder.subscriptionType
    /**
     * The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.
     */
    val syslogIp: kotlin.String? = builder.syslogIp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsm.model.CreateHsmRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHsmRequest(")
        append("clientToken=$clientToken,")
        append("eniIp=$eniIp,")
        append("externalId=$externalId,")
        append("iamRoleArn=$iamRoleArn,")
        append("sshKey=$sshKey,")
        append("subnetId=$subnetId,")
        append("subscriptionType=$subscriptionType,")
        append("syslogIp=$syslogIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (eniIp?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sshKey?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionType?.hashCode() ?: 0)
        result = 31 * result + (syslogIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHsmRequest

        if (clientToken != other.clientToken) return false
        if (eniIp != other.eniIp) return false
        if (externalId != other.externalId) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (sshKey != other.sshKey) return false
        if (subnetId != other.subnetId) return false
        if (subscriptionType != other.subscriptionType) return false
        if (syslogIp != other.syslogIp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsm.model.CreateHsmRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.
         */
        var clientToken: kotlin.String? = null
        /**
         * The IP address to assign to the HSM's ENI.
         *
         * If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.
         */
        var eniIp: kotlin.String? = null
        /**
         * The external ID from `IamRoleArn`, if present.
         */
        var externalId: kotlin.String? = null
        /**
         * The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The SSH public key to install on the HSM.
         */
        var sshKey: kotlin.String? = null
        /**
         * The identifier of the subnet in your VPC in which to place the HSM.
         */
        var subnetId: kotlin.String? = null
        /**
         * Specifies the type of subscription for the HSM.
         * + **PRODUCTION** - The HSM is being used in a production environment.
         * + **TRIAL** - The HSM is being used in a product trial.
         */
        var subscriptionType: aws.sdk.kotlin.services.cloudhsm.model.SubscriptionType? = null
        /**
         * The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.
         */
        var syslogIp: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsm.model.CreateHsmRequest) : this() {
            this.clientToken = x.clientToken
            this.eniIp = x.eniIp
            this.externalId = x.externalId
            this.iamRoleArn = x.iamRoleArn
            this.sshKey = x.sshKey
            this.subnetId = x.subnetId
            this.subscriptionType = x.subscriptionType
            this.syslogIp = x.syslogIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsm.model.CreateHsmRequest = CreateHsmRequest(this)
    }
}
