// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.model



/**
 * Contains the output of the DescribeHsm operation.
 */
class DescribeHsmResponse private constructor(builder: Builder) {
    /**
     * The Availability Zone that the HSM is in.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The identifier of the elastic network interface (ENI) attached to the HSM.
     */
    val eniId: kotlin.String? = builder.eniId
    /**
     * The IP address assigned to the HSM's ENI.
     */
    val eniIp: kotlin.String? = builder.eniIp
    /**
     * The ARN of the HSM.
     */
    val hsmArn: kotlin.String? = builder.hsmArn
    /**
     * The HSM model type.
     */
    val hsmType: kotlin.String? = builder.hsmType
    /**
     * The ARN of the IAM role assigned to the HSM.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The list of partitions on the HSM.
     */
    val partitions: List<String>? = builder.partitions
    /**
     * The serial number of the HSM.
     */
    val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The date and time that the server certificate was last updated.
     */
    val serverCertLastUpdated: kotlin.String? = builder.serverCertLastUpdated
    /**
     * The URI of the certificate server.
     */
    val serverCertUri: kotlin.String? = builder.serverCertUri
    /**
     * The HSM software version.
     */
    val softwareVersion: kotlin.String? = builder.softwareVersion
    /**
     * The date and time that the SSH key was last updated.
     */
    val sshKeyLastUpdated: kotlin.String? = builder.sshKeyLastUpdated
    /**
     * The public SSH key.
     */
    val sshPublicKey: kotlin.String? = builder.sshPublicKey
    /**
     * The status of the HSM.
     */
    val status: aws.sdk.kotlin.services.cloudhsm.model.HsmStatus? = builder.status
    /**
     * Contains additional information about the status of the HSM.
     */
    val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The identifier of the subnet that the HSM is in.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The subscription end date.
     */
    val subscriptionEndDate: kotlin.String? = builder.subscriptionEndDate
    /**
     * The subscription start date.
     */
    val subscriptionStartDate: kotlin.String? = builder.subscriptionStartDate
    /**
     * Specifies the type of subscription for the HSM.
     * + **PRODUCTION** - The HSM is being used in a production environment.
     * + **TRIAL** - The HSM is being used in a product trial.
     */
    val subscriptionType: aws.sdk.kotlin.services.cloudhsm.model.SubscriptionType? = builder.subscriptionType
    /**
     * The name of the HSM vendor.
     */
    val vendorName: kotlin.String? = builder.vendorName
    /**
     * The identifier of the VPC that the HSM is in.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsm.model.DescribeHsmResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHsmResponse(")
        append("availabilityZone=$availabilityZone,")
        append("eniId=$eniId,")
        append("eniIp=$eniIp,")
        append("hsmArn=$hsmArn,")
        append("hsmType=$hsmType,")
        append("iamRoleArn=$iamRoleArn,")
        append("partitions=$partitions,")
        append("serialNumber=$serialNumber,")
        append("serverCertLastUpdated=$serverCertLastUpdated,")
        append("serverCertUri=$serverCertUri,")
        append("softwareVersion=$softwareVersion,")
        append("sshKeyLastUpdated=$sshKeyLastUpdated,")
        append("sshPublicKey=$sshPublicKey,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("subnetId=$subnetId,")
        append("subscriptionEndDate=$subscriptionEndDate,")
        append("subscriptionStartDate=$subscriptionStartDate,")
        append("subscriptionType=$subscriptionType,")
        append("vendorName=$vendorName,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (eniId?.hashCode() ?: 0)
        result = 31 * result + (eniIp?.hashCode() ?: 0)
        result = 31 * result + (hsmArn?.hashCode() ?: 0)
        result = 31 * result + (hsmType?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (partitions?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (serverCertLastUpdated?.hashCode() ?: 0)
        result = 31 * result + (serverCertUri?.hashCode() ?: 0)
        result = 31 * result + (softwareVersion?.hashCode() ?: 0)
        result = 31 * result + (sshKeyLastUpdated?.hashCode() ?: 0)
        result = 31 * result + (sshPublicKey?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionEndDate?.hashCode() ?: 0)
        result = 31 * result + (subscriptionStartDate?.hashCode() ?: 0)
        result = 31 * result + (subscriptionType?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeHsmResponse

        if (availabilityZone != other.availabilityZone) return false
        if (eniId != other.eniId) return false
        if (eniIp != other.eniIp) return false
        if (hsmArn != other.hsmArn) return false
        if (hsmType != other.hsmType) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (partitions != other.partitions) return false
        if (serialNumber != other.serialNumber) return false
        if (serverCertLastUpdated != other.serverCertLastUpdated) return false
        if (serverCertUri != other.serverCertUri) return false
        if (softwareVersion != other.softwareVersion) return false
        if (sshKeyLastUpdated != other.sshKeyLastUpdated) return false
        if (sshPublicKey != other.sshPublicKey) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (subnetId != other.subnetId) return false
        if (subscriptionEndDate != other.subscriptionEndDate) return false
        if (subscriptionStartDate != other.subscriptionStartDate) return false
        if (subscriptionType != other.subscriptionType) return false
        if (vendorName != other.vendorName) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsm.model.DescribeHsmResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone that the HSM is in.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The identifier of the elastic network interface (ENI) attached to the HSM.
         */
        var eniId: kotlin.String? = null
        /**
         * The IP address assigned to the HSM's ENI.
         */
        var eniIp: kotlin.String? = null
        /**
         * The ARN of the HSM.
         */
        var hsmArn: kotlin.String? = null
        /**
         * The HSM model type.
         */
        var hsmType: kotlin.String? = null
        /**
         * The ARN of the IAM role assigned to the HSM.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The list of partitions on the HSM.
         */
        var partitions: List<String>? = null
        /**
         * The serial number of the HSM.
         */
        var serialNumber: kotlin.String? = null
        /**
         * The date and time that the server certificate was last updated.
         */
        var serverCertLastUpdated: kotlin.String? = null
        /**
         * The URI of the certificate server.
         */
        var serverCertUri: kotlin.String? = null
        /**
         * The HSM software version.
         */
        var softwareVersion: kotlin.String? = null
        /**
         * The date and time that the SSH key was last updated.
         */
        var sshKeyLastUpdated: kotlin.String? = null
        /**
         * The public SSH key.
         */
        var sshPublicKey: kotlin.String? = null
        /**
         * The status of the HSM.
         */
        var status: aws.sdk.kotlin.services.cloudhsm.model.HsmStatus? = null
        /**
         * Contains additional information about the status of the HSM.
         */
        var statusDetails: kotlin.String? = null
        /**
         * The identifier of the subnet that the HSM is in.
         */
        var subnetId: kotlin.String? = null
        /**
         * The subscription end date.
         */
        var subscriptionEndDate: kotlin.String? = null
        /**
         * The subscription start date.
         */
        var subscriptionStartDate: kotlin.String? = null
        /**
         * Specifies the type of subscription for the HSM.
         * + **PRODUCTION** - The HSM is being used in a production environment.
         * + **TRIAL** - The HSM is being used in a product trial.
         */
        var subscriptionType: aws.sdk.kotlin.services.cloudhsm.model.SubscriptionType? = null
        /**
         * The name of the HSM vendor.
         */
        var vendorName: kotlin.String? = null
        /**
         * The identifier of the VPC that the HSM is in.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsm.model.DescribeHsmResponse) : this() {
            this.availabilityZone = x.availabilityZone
            this.eniId = x.eniId
            this.eniIp = x.eniIp
            this.hsmArn = x.hsmArn
            this.hsmType = x.hsmType
            this.iamRoleArn = x.iamRoleArn
            this.partitions = x.partitions
            this.serialNumber = x.serialNumber
            this.serverCertLastUpdated = x.serverCertLastUpdated
            this.serverCertUri = x.serverCertUri
            this.softwareVersion = x.softwareVersion
            this.sshKeyLastUpdated = x.sshKeyLastUpdated
            this.sshPublicKey = x.sshPublicKey
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.subnetId = x.subnetId
            this.subscriptionEndDate = x.subscriptionEndDate
            this.subscriptionStartDate = x.subscriptionStartDate
            this.subscriptionType = x.subscriptionType
            this.vendorName = x.vendorName
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsm.model.DescribeHsmResponse = DescribeHsmResponse(this)
    }
}
