// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.model



/**
 * Contains the inputs for the ModifyHsm operation.
 */
class ModifyHsmRequest private constructor(builder: Builder) {
    /**
     * The new IP address for the elastic network interface (ENI) attached to the HSM.
     *
     * If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.
     */
    val eniIp: kotlin.String? = builder.eniIp
    /**
     * The new external ID.
     */
    val externalId: kotlin.String? = builder.externalId
    /**
     * The ARN of the HSM to modify.
     */
    val hsmArn: kotlin.String? = builder.hsmArn
    /**
     * The new IAM role ARN.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.
     */
    val syslogIp: kotlin.String? = builder.syslogIp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsm.model.ModifyHsmRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyHsmRequest(")
        append("eniIp=$eniIp,")
        append("externalId=$externalId,")
        append("hsmArn=$hsmArn,")
        append("iamRoleArn=$iamRoleArn,")
        append("subnetId=$subnetId,")
        append("syslogIp=$syslogIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eniIp?.hashCode() ?: 0
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (hsmArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (syslogIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyHsmRequest

        if (eniIp != other.eniIp) return false
        if (externalId != other.externalId) return false
        if (hsmArn != other.hsmArn) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (subnetId != other.subnetId) return false
        if (syslogIp != other.syslogIp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsm.model.ModifyHsmRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The new IP address for the elastic network interface (ENI) attached to the HSM.
         *
         * If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.
         */
        var eniIp: kotlin.String? = null
        /**
         * The new external ID.
         */
        var externalId: kotlin.String? = null
        /**
         * The ARN of the HSM to modify.
         */
        var hsmArn: kotlin.String? = null
        /**
         * The new IAM role ARN.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.
         */
        var subnetId: kotlin.String? = null
        /**
         * The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.
         */
        var syslogIp: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsm.model.ModifyHsmRequest) : this() {
            this.eniIp = x.eniIp
            this.externalId = x.externalId
            this.hsmArn = x.hsmArn
            this.iamRoleArn = x.iamRoleArn
            this.subnetId = x.subnetId
            this.syslogIp = x.syslogIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsm.model.ModifyHsmRequest = ModifyHsmRequest(this)
    }
}
