// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudhsm.model.CloudHsmException
import aws.sdk.kotlin.services.cloudhsm.model.CreateHsmResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateHsmOperationDeserializer: HttpDeserialize<CreateHsmResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateHsmResponse {
        if (!response.status.isSuccess()) {
            throwCreateHsmError(context, response)
        }
        val builder = CreateHsmResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateHsmOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateHsmError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmInternalException" -> CloudHsmInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudHsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHsmOperationBody(builder: CreateHsmResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HSMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HsmArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HSMARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HSMARN_DESCRIPTOR.index -> builder.hsmArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
