// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudhsm.model.CloudHsmException
import aws.sdk.kotlin.services.cloudhsm.model.CloudHsmObjectState
import aws.sdk.kotlin.services.cloudhsm.model.DescribeHapgResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeHapgOperationDeserializer: HttpDeserialize<DescribeHapgResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeHapgResponse {
        if (!response.status.isSuccess()) {
            throwDescribeHapgError(context, response)
        }
        val builder = DescribeHapgResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHapgOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeHapgError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmInternalException" -> CloudHsmInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudHsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHapgOperationBody(builder: DescribeHapgResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HAPGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HapgArn"))
    val HAPGSERIAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HapgSerial"))
    val HSMSLASTACTIONFAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HsmsLastActionFailed"))
    val HSMSPENDINGDELETION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HsmsPendingDeletion"))
    val HSMSPENDINGREGISTRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HsmsPendingRegistration"))
    val LABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Label"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModifiedTimestamp"))
    val PARTITIONSERIALLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PartitionSerialList"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HAPGARN_DESCRIPTOR)
        field(HAPGSERIAL_DESCRIPTOR)
        field(HSMSLASTACTIONFAILED_DESCRIPTOR)
        field(HSMSPENDINGDELETION_DESCRIPTOR)
        field(HSMSPENDINGREGISTRATION_DESCRIPTOR)
        field(LABEL_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(PARTITIONSERIALLIST_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HAPGARN_DESCRIPTOR.index -> builder.hapgArn = deserializeString()
                HAPGSERIAL_DESCRIPTOR.index -> builder.hapgSerial = deserializeString()
                HSMSLASTACTIONFAILED_DESCRIPTOR.index -> builder.hsmsLastActionFailed =
                    deserializer.deserializeList(HSMSLASTACTIONFAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HSMSPENDINGDELETION_DESCRIPTOR.index -> builder.hsmsPendingDeletion =
                    deserializer.deserializeList(HSMSPENDINGDELETION_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HSMSPENDINGREGISTRATION_DESCRIPTOR.index -> builder.hsmsPendingRegistration =
                    deserializer.deserializeList(HSMSPENDINGREGISTRATION_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LABEL_DESCRIPTOR.index -> builder.label = deserializeString()
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimestamp = deserializeString()
                PARTITIONSERIALLIST_DESCRIPTOR.index -> builder.partitionSerialList =
                    deserializer.deserializeList(PARTITIONSERIALLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { CloudHsmObjectState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
