// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudhsm.model.CloudHsmException
import aws.sdk.kotlin.services.cloudhsm.model.DescribeHsmResponse
import aws.sdk.kotlin.services.cloudhsm.model.HsmStatus
import aws.sdk.kotlin.services.cloudhsm.model.SubscriptionType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeHsmOperationDeserializer: HttpDeserialize<DescribeHsmResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeHsmResponse {
        if (!response.status.isSuccess()) {
            throwDescribeHsmError(context, response)
        }
        val builder = DescribeHsmResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHsmOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeHsmError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmInternalException" -> CloudHsmInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudHsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHsmOperationBody(builder: DescribeHsmResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZone"))
    val ENIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EniId"))
    val ENIIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EniIp"))
    val HSMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HsmArn"))
    val HSMTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HsmType"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRoleArn"))
    val PARTITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Partitions"))
    val SERIALNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SerialNumber"))
    val SERVERCERTLASTUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServerCertLastUpdated"))
    val SERVERCERTURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServerCertUri"))
    val SOFTWAREVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SoftwareVersion"))
    val SSHKEYLASTUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SshKeyLastUpdated"))
    val SSHPUBLICKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SshPublicKey"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusDetails"))
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubnetId"))
    val SUBSCRIPTIONENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscriptionEndDate"))
    val SUBSCRIPTIONSTARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscriptionStartDate"))
    val SUBSCRIPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscriptionType"))
    val VENDORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VendorName"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(ENIID_DESCRIPTOR)
        field(ENIIP_DESCRIPTOR)
        field(HSMARN_DESCRIPTOR)
        field(HSMTYPE_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(PARTITIONS_DESCRIPTOR)
        field(SERIALNUMBER_DESCRIPTOR)
        field(SERVERCERTLASTUPDATED_DESCRIPTOR)
        field(SERVERCERTURI_DESCRIPTOR)
        field(SOFTWAREVERSION_DESCRIPTOR)
        field(SSHKEYLASTUPDATED_DESCRIPTOR)
        field(SSHPUBLICKEY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(SUBSCRIPTIONENDDATE_DESCRIPTOR)
        field(SUBSCRIPTIONSTARTDATE_DESCRIPTOR)
        field(SUBSCRIPTIONTYPE_DESCRIPTOR)
        field(VENDORNAME_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABILITYZONE_DESCRIPTOR.index -> builder.availabilityZone = deserializeString()
                ENIID_DESCRIPTOR.index -> builder.eniId = deserializeString()
                ENIIP_DESCRIPTOR.index -> builder.eniIp = deserializeString()
                HSMARN_DESCRIPTOR.index -> builder.hsmArn = deserializeString()
                HSMTYPE_DESCRIPTOR.index -> builder.hsmType = deserializeString()
                IAMROLEARN_DESCRIPTOR.index -> builder.iamRoleArn = deserializeString()
                PARTITIONS_DESCRIPTOR.index -> builder.partitions =
                    deserializer.deserializeList(PARTITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SERIALNUMBER_DESCRIPTOR.index -> builder.serialNumber = deserializeString()
                SERVERCERTLASTUPDATED_DESCRIPTOR.index -> builder.serverCertLastUpdated = deserializeString()
                SERVERCERTURI_DESCRIPTOR.index -> builder.serverCertUri = deserializeString()
                SOFTWAREVERSION_DESCRIPTOR.index -> builder.softwareVersion = deserializeString()
                SSHKEYLASTUPDATED_DESCRIPTOR.index -> builder.sshKeyLastUpdated = deserializeString()
                SSHPUBLICKEY_DESCRIPTOR.index -> builder.sshPublicKey = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { HsmStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeString()
                SUBNETID_DESCRIPTOR.index -> builder.subnetId = deserializeString()
                SUBSCRIPTIONENDDATE_DESCRIPTOR.index -> builder.subscriptionEndDate = deserializeString()
                SUBSCRIPTIONSTARTDATE_DESCRIPTOR.index -> builder.subscriptionStartDate = deserializeString()
                SUBSCRIPTIONTYPE_DESCRIPTOR.index -> builder.subscriptionType = deserializeString().let { SubscriptionType.fromValue(it) }
                VENDORNAME_DESCRIPTOR.index -> builder.vendorName = deserializeString()
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
