// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudhsm.model.CloudHsmException
import aws.sdk.kotlin.services.cloudhsm.model.DescribeLunaClientResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeLunaClientOperationDeserializer: HttpDeserialize<DescribeLunaClientResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLunaClientResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLunaClientError(context, response)
        }
        val builder = DescribeLunaClientResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLunaClientOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLunaClientError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmInternalException" -> CloudHsmInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudHsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLunaClientOperationBody(builder: DescribeLunaClientResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CERTIFICATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Certificate"))
    val CERTIFICATEFINGERPRINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CertificateFingerprint"))
    val CLIENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientArn"))
    val LABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Label"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModifiedTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATE_DESCRIPTOR)
        field(CERTIFICATEFINGERPRINT_DESCRIPTOR)
        field(CLIENTARN_DESCRIPTOR)
        field(LABEL_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATE_DESCRIPTOR.index -> builder.certificate = deserializeString()
                CERTIFICATEFINGERPRINT_DESCRIPTOR.index -> builder.certificateFingerprint = deserializeString()
                CLIENTARN_DESCRIPTOR.index -> builder.clientArn = deserializeString()
                LABEL_DESCRIPTOR.index -> builder.label = deserializeString()
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimestamp = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
