// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudhsm.model.CloudHsmException
import aws.sdk.kotlin.services.cloudhsm.model.ModifyHapgResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyHapgOperationDeserializer: HttpDeserialize<ModifyHapgResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyHapgResponse {
        if (!response.status.isSuccess()) {
            throwModifyHapgError(context, response)
        }
        val builder = ModifyHapgResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyHapgOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyHapgError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmInternalException" -> CloudHsmInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudHsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyHapgOperationBody(builder: ModifyHapgResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HAPGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HapgArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HAPGARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HAPGARN_DESCRIPTOR.index -> builder.hapgArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
