// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudwatch.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudwatch.model.*
import aws.sdk.kotlin.services.cloudwatch.model.DeleteAlarmsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DeleteAlarmsResponse
import aws.sdk.kotlin.services.cloudwatch.model.DeleteAnomalyDetectorRequest
import aws.sdk.kotlin.services.cloudwatch.model.DeleteAnomalyDetectorResponse
import aws.sdk.kotlin.services.cloudwatch.model.DeleteDashboardsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DeleteDashboardsResponse
import aws.sdk.kotlin.services.cloudwatch.model.DeleteInsightRulesRequest
import aws.sdk.kotlin.services.cloudwatch.model.DeleteInsightRulesResponse
import aws.sdk.kotlin.services.cloudwatch.model.DeleteMetricStreamRequest
import aws.sdk.kotlin.services.cloudwatch.model.DeleteMetricStreamResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmHistoryRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmHistoryResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsForMetricRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsForMetricResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeInsightRulesRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeInsightRulesResponse
import aws.sdk.kotlin.services.cloudwatch.model.DisableAlarmActionsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DisableAlarmActionsResponse
import aws.sdk.kotlin.services.cloudwatch.model.DisableInsightRulesRequest
import aws.sdk.kotlin.services.cloudwatch.model.DisableInsightRulesResponse
import aws.sdk.kotlin.services.cloudwatch.model.EnableAlarmActionsRequest
import aws.sdk.kotlin.services.cloudwatch.model.EnableAlarmActionsResponse
import aws.sdk.kotlin.services.cloudwatch.model.EnableInsightRulesRequest
import aws.sdk.kotlin.services.cloudwatch.model.EnableInsightRulesResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetDashboardRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetDashboardResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStatisticsRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStatisticsResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricWidgetImageRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricWidgetImageResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListDashboardsRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListDashboardsResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricStreamsRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricStreamsResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricsRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricsResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutAnomalyDetectorRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutAnomalyDetectorResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutCompositeAlarmRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutCompositeAlarmResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutDashboardRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutDashboardResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutInsightRuleRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutInsightRuleResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricDataRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricDataResponse
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamRequest
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamResponse
import aws.sdk.kotlin.services.cloudwatch.model.SetAlarmStateRequest
import aws.sdk.kotlin.services.cloudwatch.model.SetAlarmStateResponse
import aws.sdk.kotlin.services.cloudwatch.model.StartMetricStreamsRequest
import aws.sdk.kotlin.services.cloudwatch.model.StartMetricStreamsResponse
import aws.sdk.kotlin.services.cloudwatch.model.StopMetricStreamsRequest
import aws.sdk.kotlin.services.cloudwatch.model.StopMetricStreamsResponse
import aws.sdk.kotlin.services.cloudwatch.model.TagResourceRequest
import aws.sdk.kotlin.services.cloudwatch.model.TagResourceResponse
import aws.sdk.kotlin.services.cloudwatch.model.UntagResourceRequest
import aws.sdk.kotlin.services.cloudwatch.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon CloudWatch monitors your Amazon Web Services (Amazon Web Services) resources and the applications you run on Amazon Web Services in real time. You can use CloudWatch to collect and track metrics, which are the variables you want to measure for your resources and applications.
 *
 * CloudWatch alarms send notifications or automatically change the resources you are monitoring based on rules that you define. For example, you can monitor the CPU usage and disk reads and writes of your Amazon EC2 instances. Then, use this data to determine whether you should launch additional instances to handle increased load. You can also use this data to stop under-used instances to save money.
 *
 * In addition to monitoring the built-in metrics that come with Amazon Web Services, you can monitor your own custom metrics. With CloudWatch, you gain system-wide visibility into resource utilization, application performance, and operational health.
 */
public interface CloudWatchClient : SdkClient {

    override val serviceName: String
        get() = "CloudWatch"
    /**
     * CloudWatchClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CloudWatchClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCloudWatchClient(config)
        }

        public operator fun invoke(config: Config): CloudWatchClient = DefaultCloudWatchClient(config)

        /**
         * Construct a [CloudWatchClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CloudWatchClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCloudWatchClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified alarms. You can delete up to 100 alarms in one operation. However, this total can include no more than one composite alarm. For example, you could delete 99 metric alarms and one composite alarms with one operation, but you can't delete two composite alarms with one operation.
     *
     *  In the event of an error, no alarms are deleted.
     *
     * It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can't delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete.
     *
     * To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the `AlarmRule` of one of the alarms to `False`.
     *
     * Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path.
     */
    public suspend fun deleteAlarms(input: DeleteAlarmsRequest): DeleteAlarmsResponse

    /**
     * Deletes the specified anomaly detection model from your account.
     */
    public suspend fun deleteAnomalyDetector(input: DeleteAnomalyDetectorRequest = DeleteAnomalyDetectorRequest {}): DeleteAnomalyDetectorResponse

    /**
     * Deletes all dashboards that you specify. You can specify up to 100 dashboards to delete. If there is an error during this call, no dashboards are deleted.
     */
    public suspend fun deleteDashboards(input: DeleteDashboardsRequest): DeleteDashboardsResponse

    /**
     * Permanently deletes the specified Contributor Insights rules.
     *
     * If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.
     */
    public suspend fun deleteInsightRules(input: DeleteInsightRulesRequest): DeleteInsightRulesResponse

    /**
     * Permanently deletes the metric stream that you specify.
     */
    public suspend fun deleteMetricStream(input: DeleteMetricStreamRequest): DeleteMetricStreamResponse

    /**
     * Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for either all metric alarms or all composite alarms are returned.
     *
     * CloudWatch retains the history of an alarm even if you delete the alarm.
     *
     * To use this operation and return information about a composite alarm, you must be signed on with the `cloudwatch:DescribeAlarmHistory` permission that is scoped to `*`. You can't return information about composite alarms if your `cloudwatch:DescribeAlarmHistory` permission has a narrower scope.
     */
    public suspend fun describeAlarmHistory(input: DescribeAlarmHistoryRequest = DescribeAlarmHistoryRequest {}): DescribeAlarmHistoryResponse

    /**
     * Retrieves the specified alarms. You can filter the results by specifying a prefix for the alarm name, the alarm state, or a prefix for any action.
     *
     * To use this operation and return information about composite alarms, you must be signed on with the `cloudwatch:DescribeAlarms` permission that is scoped to `*`. You can't return information about composite alarms if your `cloudwatch:DescribeAlarms` permission has a narrower scope.
     */
    public suspend fun describeAlarms(input: DescribeAlarmsRequest = DescribeAlarmsRequest {}): DescribeAlarmsResponse

    /**
     * Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit.
     *
     * This operation retrieves only standard alarms that are based on the specified metric. It does not return alarms based on math expressions that use the specified metric, or composite alarms that use the specified metric.
     */
    public suspend fun describeAlarmsForMetric(input: DescribeAlarmsForMetricRequest): DescribeAlarmsForMetricResponse

    /**
     * Lists the anomaly detection models that you have created in your account. For single metric anomaly detectors, you can list all of the models in your account or filter the results to only the models that are related to a certain namespace, metric name, or metric dimension. For metric math anomaly detectors, you can list them by adding `METRIC_MATH` to the `AnomalyDetectorTypes` array. This will return all metric math anomaly detectors in your account.
     */
    public suspend fun describeAnomalyDetectors(input: DescribeAnomalyDetectorsRequest = DescribeAnomalyDetectorsRequest {}): DescribeAnomalyDetectorsResponse

    /**
     * Returns a list of all the Contributor Insights rules in your account.
     *
     * For more information about Contributor Insights, see [Using Contributor Insights to Analyze High-Cardinality Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
     */
    public suspend fun describeInsightRules(input: DescribeInsightRulesRequest = DescribeInsightRulesRequest {}): DescribeInsightRulesResponse

    /**
     * Disables the actions for the specified alarms. When an alarm's actions are disabled, the alarm actions do not execute when the alarm state changes.
     */
    public suspend fun disableAlarmActions(input: DisableAlarmActionsRequest): DisableAlarmActionsResponse

    /**
     * Disables the specified Contributor Insights rules. When rules are disabled, they do not analyze log groups and do not incur costs.
     */
    public suspend fun disableInsightRules(input: DisableInsightRulesRequest): DisableInsightRulesResponse

    /**
     * Enables the actions for the specified alarms.
     */
    public suspend fun enableAlarmActions(input: EnableAlarmActionsRequest): EnableAlarmActionsResponse

    /**
     * Enables the specified Contributor Insights rules. When rules are enabled, they immediately begin analyzing log data.
     */
    public suspend fun enableInsightRules(input: EnableInsightRulesRequest): EnableInsightRulesResponse

    /**
     * Displays the details of the dashboard that you specify.
     *
     * To copy an existing dashboard, use `GetDashboard`, and then use the data returned within `DashboardBody` as the template for the new dashboard when you call `PutDashboard` to create the copy.
     */
    public suspend fun getDashboard(input: GetDashboardRequest): GetDashboardResponse

    /**
     * This operation returns the time series data collected by a Contributor Insights rule. The data includes the identity and number of contributors to the log group.
     *
     * You can also optionally return one or more statistics about each data point in the time series. These statistics can include the following:
     * + `UniqueContributors` -- the number of unique contributors for each data point.
     * + `MaxContributorValue` -- the value of the top contributor for each data point. The identity of the contributor might change for each data point in the graph.If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the highest sum in the log field specified by the rule's `Value`, during that period.
     * + `SampleCount` -- the number of data points matched by the rule.
     * + `Sum` -- the sum of the values from all contributors during the time period represented by that data point.
     * + `Minimum` -- the minimum value from a single observation during the time period represented by that data point.
     * + `Maximum` -- the maximum value from a single observation during the time period represented by that data point.
     * + `Average` -- the average value from all contributors during the time period represented by that data point.
     */
    public suspend fun getInsightRuleReport(input: GetInsightRuleReportRequest): GetInsightRuleReportResponse

    /**
     * You can use the `GetMetricData` API to retrieve CloudWatch metric values. The operation can also include a CloudWatch Metrics Insights query, and one or more metric math functions.
     *
     * A `GetMetricData` operation that does not include a query can retrieve as many as 500 different metrics in a single request, with a total of as many as 100,800 data points. You can also optionally perform metric math expressions on the values of the returned statistics, to create new time series that represent new insights into your data. For example, using Lambda metrics, you could divide the Errors metric by the Invocations metric to get an error rate time series. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *Amazon CloudWatch User Guide*.
     *
     * If you include a Metrics Insights query, each `GetMetricData` operation can include only one query. But the same `GetMetricData` operation can also retrieve other metrics. Metrics Insights queries can query only the most recent three hours of metric data. For more information about Metrics Insights, see [Query your metrics with CloudWatch Metrics Insights](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/query_with_cloudwatch-metrics-insights.html).
     *
     * Calls to the `GetMetricData` API have a different pricing structure than calls to `GetMetricStatistics`. For more information about pricing, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
     *
     * Amazon CloudWatch retains metric data as follows:
     * + Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a `StorageResolution` of 1.
     * + Data points with a period of 60 seconds (1-minute) are available for 15 days.
     * + Data points with a period of 300 seconds (5-minute) are available for 63 days.
     * + Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).
     *
     * Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.
     *
     * If you omit `Unit` in your request, all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
     *
     * **Using Metrics Insights queries with metric math**
     *
     * You can't mix a Metric Insights query and metric math syntax in the same expression, but you can reference results from a Metrics Insights query within other Metric math expressions. A Metrics Insights query without a **GROUP BY** clause returns a single time-series (TS), and can be used as input for a metric math expression that expects a single time series. A Metrics Insights query with a **GROUP BY** clause returns an array of time-series (TS&#91;&#93;), and can be used as input for a metric math expression that expects an array of time series.
     */
    public suspend fun getMetricData(input: GetMetricDataRequest): GetMetricDataResponse

    /**
     * Gets statistics for the specified metric.
     *
     * The maximum number of data points returned from a single call is 1,440. If you request more than 1,440 data points, CloudWatch returns an error. To reduce the number of data points, you can narrow the specified time range and make multiple requests across adjacent time ranges, or you can increase the specified period. Data points are not returned in chronological order.
     *
     * CloudWatch aggregates data points based on the length of the period that you specify. For example, if you request statistics with a one-hour period, CloudWatch aggregates all data points with time stamps that fall within each one-hour period. Therefore, the number of values aggregated by CloudWatch is larger than the number of data points returned.
     *
     * CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:
     * + The SampleCount value of the statistic set is 1.
     * + The Min and the Max values of the statistic set are equal.
     *
     * Percentile statistics are not available for metrics when any of the metric values are negative numbers.
     *
     * Amazon CloudWatch retains metric data as follows:
     * + Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a `StorageResolution` of 1.
     * + Data points with a period of 60 seconds (1-minute) are available for 15 days.
     * + Data points with a period of 300 seconds (5-minute) are available for 63 days.
     * + Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).
     *
     * Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.
     *
     * CloudWatch started retaining 5-minute and 1-hour metric data as of July 9, 2016.
     *
     * For information about metrics and dimensions supported by Amazon Web Services services, see the [Amazon CloudWatch Metrics and Dimensions Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html) in the *Amazon CloudWatch User Guide*.
     */
    public suspend fun getMetricStatistics(input: GetMetricStatisticsRequest): GetMetricStatisticsResponse

    /**
     * Returns information about the metric stream that you specify.
     */
    public suspend fun getMetricStream(input: GetMetricStreamRequest): GetMetricStreamResponse

    /**
     * You can use the `GetMetricWidgetImage` API to retrieve a snapshot graph of one or more Amazon CloudWatch metrics as a bitmap image. You can then embed this image into your services and products, such as wiki pages, reports, and documents. You could also retrieve images regularly, such as every minute, and create your own custom live dashboard.
     *
     * The graph you retrieve can include all CloudWatch metric graph features, including metric math and horizontal and vertical annotations.
     *
     * There is a limit of 20 transactions per second for this API. Each `GetMetricWidgetImage` action has the following limits:
     * + As many as 100 metrics in the graph.
     * + Up to 100 KB uncompressed payload.
     */
    public suspend fun getMetricWidgetImage(input: GetMetricWidgetImageRequest): GetMetricWidgetImageResponse

    /**
     * Returns a list of the dashboards for your account. If you include `DashboardNamePrefix`, only those dashboards with names starting with the prefix are listed. Otherwise, all dashboards in your account are listed.
     *
     * `ListDashboards` returns up to 1000 results on one page. If there are more than 1000 dashboards, you can call `ListDashboards` again and include the value you received for `NextToken` in the first call, to receive the next 1000 results.
     */
    public suspend fun listDashboards(input: ListDashboardsRequest = ListDashboardsRequest {}): ListDashboardsResponse

    /**
     * Returns a list of metric streams in this account.
     */
    public suspend fun listMetricStreams(input: ListMetricStreamsRequest = ListMetricStreamsRequest {}): ListMetricStreamsResponse

    /**
     * List the specified metrics. You can use the returned metrics with [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html) to obtain statistical data.
     *
     * Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with subsequent calls.
     *
     * After you create a metric, allow up to 15 minutes before the metric appears. You can see statistics about the metric sooner by using [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
     *
     * `ListMetrics` doesn't return information about metrics if those metrics haven't reported data in the past two weeks. To retrieve those metrics, use [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
     */
    public suspend fun listMetrics(input: ListMetricsRequest = ListMetricsRequest {}): ListMetricsResponse

    /**
     * Displays the tags associated with a CloudWatch resource. Currently, alarms and Contributor Insights rules support tagging.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates an anomaly detection model for a CloudWatch metric. You can use the model to display a band of expected normal values when the metric is graphed.
     *
     * For more information, see [CloudWatch Anomaly Detection](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html).
     */
    public suspend fun putAnomalyDetector(input: PutAnomalyDetectorRequest = PutAnomalyDetectorRequest {}): PutAnomalyDetectorResponse

    /**
     * Creates or updates a *composite alarm*. When you create a composite alarm, you specify a rule expression for the alarm that takes into account the alarm states of other alarms that you have created. The composite alarm goes into ALARM state only if all conditions of the rule are met.
     *
     * The alarms specified in a composite alarm's rule expression can include metric alarms and other composite alarms. The rule expression of a composite alarm can include as many as 100 underlying alarms. Any single alarm can be included in the rule expressions of as many as 150 composite alarms.
     *
     * Using composite alarms can reduce alarm noise. You can create multiple metric alarms, and also create a composite alarm and set up alerts only for the composite alarm. For example, you could create a composite alarm that goes into ALARM state only when more than one of the underlying metric alarms are in ALARM state.
     *
     * Currently, the only alarm actions that can be taken by composite alarms are notifying SNS topics.
     *
     * It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can't delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete.
     *
     * To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the `AlarmRule` of one of the alarms to `False`.
     *
     * Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path.
     *
     * When this operation creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed. For a composite alarm, this initial time after creation is the only time that the alarm can be in `INSUFFICIENT_DATA` state.
     *
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.
     *
     * To use this operation, you must be signed on with the `cloudwatch:PutCompositeAlarm` permission that is scoped to `*`. You can't create a composite alarms if your `cloudwatch:PutCompositeAlarm` permission has a narrower scope.
     *
     * If you are an IAM user, you must have `iam:CreateServiceLinkedRole` to create a composite alarm that has Systems Manager OpsItem actions.
     */
    public suspend fun putCompositeAlarm(input: PutCompositeAlarmRequest): PutCompositeAlarmResponse

    /**
     * Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here.
     *
     * All dashboards in your account are global, not region-specific.
     *
     * A simple way to create a dashboard using `PutDashboard` is to copy an existing dashboard. To copy an existing dashboard using the console, you can load the dashboard and then use the View/edit source command in the Actions menu to display the JSON block for that dashboard. Another way to copy a dashboard is to use `GetDashboard`, and then use the data returned within `DashboardBody` as the template for the new dashboard when you call `PutDashboard`.
     *
     * When you create a dashboard with `PutDashboard`, a good practice is to add a text widget at the top of the dashboard with a message that the dashboard was created by script and should not be changed in the console. This message could also point console users to the location of the `DashboardBody` script or the CloudFormation template used to create the dashboard.
     */
    public suspend fun putDashboard(input: PutDashboardRequest): PutDashboardResponse

    /**
     * Creates a Contributor Insights rule. Rules evaluate log events in a CloudWatch Logs log group, enabling you to find contributor data for the log events in that log group. For more information, see [Using Contributor Insights to Analyze High-Cardinality Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
     *
     * If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.
     */
    public suspend fun putInsightRule(input: PutInsightRuleRequest): PutInsightRuleResponse

    /**
     * Creates or updates an alarm and associates it with the specified metric, metric math expression, or anomaly detection model.
     *
     * Alarms based on anomaly detection models cannot have Auto Scaling actions.
     *
     * When this operation creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
     *
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.
     *
     * If you are an IAM user, you must have Amazon EC2 permissions for some alarm operations:
     * + The `iam:CreateServiceLinkedRole` for all alarms with EC2 actions
     * + The `iam:CreateServiceLinkedRole` to create an alarm with Systems Manager OpsItem actions.
     *
     * The first time you create an alarm in the Amazon Web Services Management Console, the CLI, or by using the PutMetricAlarm API, CloudWatch creates the necessary service-linked role for you. The service-linked roles are called `AWSServiceRoleForCloudWatchEvents` and `AWSServiceRoleForCloudWatchAlarms_ActionSSM`. For more information, see [Amazon Web Services service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role).
     *
     * **Cross-account alarms**
     *
     * You can set an alarm on metrics in the current account, or in another account. To create a cross-account alarm that watches a metric in a different account, you must have completed the following pre-requisites:
     * + The account where the metrics are located (the *sharing account*) must already have a sharing role named **CloudWatch-CrossAccountSharingRole**. If it does not already have this role, you must create it using the instructions in **Set up a sharing account** in [ Cross-account cross-Region CloudWatch console](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html#enable-cross-account-cross-Region). The policy for that role must grant access to the ID of the account where you are creating the alarm.
     * + The account where you are creating the alarm (the *monitoring account*) must already have a service-linked role named **AWSServiceRoleForCloudWatchCrossAccount** to allow CloudWatch to assume the sharing role in the sharing account. If it does not, you must create it following the directions in **Set up a monitoring account** in [ Cross-account cross-Region CloudWatch console](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html#enable-cross-account-cross-Region).
     */
    public suspend fun putMetricAlarm(input: PutMetricAlarmRequest): PutMetricAlarmResponse

    /**
     * Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metric. If the specified metric does not exist, CloudWatch creates the metric. When CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
     *
     * You can publish either individual data points in the `Value` field, or arrays of values and the number of times each value occurred during the period by using the `Values` and `Counts` fields in the `MetricDatum` structure. Using the `Values` and `Counts` method enables you to publish up to 150 values per metric with one `PutMetricData` request, and supports retrieving percentile statistics on this data.
     *
     * Each `PutMetricData` request is limited to 40 KB in size for HTTP POST requests. You can send a payload compressed by gzip. Each request is also limited to no more than 20 different metrics.
     *
     * Although the `Value` parameter accepts numbers of type `Double`, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.
     *
     * You can use up to 10 dimensions per metric to further clarify what data the metric collects. Each dimension consists of a Name and Value pair. For more information about specifying dimensions, see [Publishing Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html) in the *Amazon CloudWatch User Guide*.
     *
     * You specify the time stamp to be associated with each data point. You can specify time stamps that are as much as two weeks before the current date, and as much as 2 hours after the current day and time.
     *
     * Data points with time stamps from 24 hours ago or longer can take at least 48 hours to become available for [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html) from the time they are submitted. Data points with time stamps between 3 and 24 hours ago can take as much as 2 hours to become available for for [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
     *
     * CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:
     * + The `SampleCount` value of the statistic set is 1 and `Min`, `Max`, and `Sum` are all equal.
     * + The `Min` and `Max` are equal, and `Sum` is equal to `Min` multiplied by `SampleCount`.
     */
    public suspend fun putMetricData(input: PutMetricDataRequest): PutMetricDataResponse

    /**
     * Creates or updates a metric stream. Metric streams can automatically stream CloudWatch metrics to Amazon Web Services destinations including Amazon S3 and to many third-party solutions.
     *
     * For more information, see [ Using Metric Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Metric-Streams.html).
     *
     * To create a metric stream, you must be logged on to an account that has the `iam:PassRole` permission and either the `CloudWatchFullAccess` policy or the `cloudwatch:PutMetricStream` permission.
     *
     * When you create or update a metric stream, you choose one of the following:
     * + Stream metrics from all metric namespaces in the account.
     * + Stream metrics from all metric namespaces in the account, except for the namespaces that you list in `ExcludeFilters`.
     * + Stream metrics from only the metric namespaces that you list in `IncludeFilters`.
     *
     * By default, a metric stream always sends the `MAX`, `MIN`, `SUM`, and `SAMPLECOUNT` statistics for each metric that is streamed. You can use the `StatisticsConfigurations` parameter to have the metric stream also send additional statistics in the stream. Streaming additional statistics incurs additional costs. For more information, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
     *
     * When you use `PutMetricStream` to create a new metric stream, the stream is created in the `running` state. If you use it to update an existing stream, the state of the stream is not changed.
     */
    public suspend fun putMetricStream(input: PutMetricStreamRequest): PutMetricStreamResponse

    /**
     * Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to `ALARM` sends an SNS message.
     *
     * Metric alarms returns to their actual state quickly, often within seconds. Because the metric alarm state change happens quickly, it is typically only visible in the alarm's **History** tab in the Amazon CloudWatch console or through [DescribeAlarmHistory](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarmHistory.html).
     *
     * If you use `SetAlarmState` on a composite alarm, the composite alarm is not guaranteed to return to its actual state. It returns to its actual state only once any of its children alarms change state. It is also reevaluated if you update its configuration.
     *
     * If an alarm triggers EC2 Auto Scaling policies or application Auto Scaling policies, you must include information in the `StateReasonData` parameter to enable the policy to take the correct action.
     */
    public suspend fun setAlarmState(input: SetAlarmStateRequest): SetAlarmStateResponse

    /**
     * Starts the streaming of metrics for one or more of your metric streams.
     */
    public suspend fun startMetricStreams(input: StartMetricStreamsRequest): StartMetricStreamsResponse

    /**
     * Stops the streaming of metrics for one or more of your metric streams.
     */
    public suspend fun stopMetricStreams(input: StopMetricStreamsRequest): StopMetricStreamsResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch resource. Currently, the only CloudWatch resources that can be tagged are alarms and Contributor Insights rules.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     *
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     *
     * You can use the `TagResource` action with an alarm that already has tags. If you specify a new tag key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a CloudWatch resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Deletes the specified alarms. You can delete up to 100 alarms in one operation. However, this total can include no more than one composite alarm. For example, you could delete 99 metric alarms and one composite alarms with one operation, but you can't delete two composite alarms with one operation.
 *
 *  In the event of an error, no alarms are deleted.
 *
 * It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can't delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete.
 *
 * To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the `AlarmRule` of one of the alarms to `False`.
 *
 * Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path.
 */
public suspend inline fun CloudWatchClient.deleteAlarms(crossinline block: DeleteAlarmsRequest.Builder.() -> Unit): DeleteAlarmsResponse = deleteAlarms(DeleteAlarmsRequest.Builder().apply(block).build())

/**
 * Deletes the specified anomaly detection model from your account.
 */
public suspend inline fun CloudWatchClient.deleteAnomalyDetector(crossinline block: DeleteAnomalyDetectorRequest.Builder.() -> Unit): DeleteAnomalyDetectorResponse = deleteAnomalyDetector(DeleteAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Deletes all dashboards that you specify. You can specify up to 100 dashboards to delete. If there is an error during this call, no dashboards are deleted.
 */
public suspend inline fun CloudWatchClient.deleteDashboards(crossinline block: DeleteDashboardsRequest.Builder.() -> Unit): DeleteDashboardsResponse = deleteDashboards(DeleteDashboardsRequest.Builder().apply(block).build())

/**
 * Permanently deletes the specified Contributor Insights rules.
 *
 * If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.
 */
public suspend inline fun CloudWatchClient.deleteInsightRules(crossinline block: DeleteInsightRulesRequest.Builder.() -> Unit): DeleteInsightRulesResponse = deleteInsightRules(DeleteInsightRulesRequest.Builder().apply(block).build())

/**
 * Permanently deletes the metric stream that you specify.
 */
public suspend inline fun CloudWatchClient.deleteMetricStream(crossinline block: DeleteMetricStreamRequest.Builder.() -> Unit): DeleteMetricStreamResponse = deleteMetricStream(DeleteMetricStreamRequest.Builder().apply(block).build())

/**
 * Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for either all metric alarms or all composite alarms are returned.
 *
 * CloudWatch retains the history of an alarm even if you delete the alarm.
 *
 * To use this operation and return information about a composite alarm, you must be signed on with the `cloudwatch:DescribeAlarmHistory` permission that is scoped to `*`. You can't return information about composite alarms if your `cloudwatch:DescribeAlarmHistory` permission has a narrower scope.
 */
public suspend inline fun CloudWatchClient.describeAlarmHistory(crossinline block: DescribeAlarmHistoryRequest.Builder.() -> Unit): DescribeAlarmHistoryResponse = describeAlarmHistory(DescribeAlarmHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the specified alarms. You can filter the results by specifying a prefix for the alarm name, the alarm state, or a prefix for any action.
 *
 * To use this operation and return information about composite alarms, you must be signed on with the `cloudwatch:DescribeAlarms` permission that is scoped to `*`. You can't return information about composite alarms if your `cloudwatch:DescribeAlarms` permission has a narrower scope.
 */
public suspend inline fun CloudWatchClient.describeAlarms(crossinline block: DescribeAlarmsRequest.Builder.() -> Unit): DescribeAlarmsResponse = describeAlarms(DescribeAlarmsRequest.Builder().apply(block).build())

/**
 * Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit.
 *
 * This operation retrieves only standard alarms that are based on the specified metric. It does not return alarms based on math expressions that use the specified metric, or composite alarms that use the specified metric.
 */
public suspend inline fun CloudWatchClient.describeAlarmsForMetric(crossinline block: DescribeAlarmsForMetricRequest.Builder.() -> Unit): DescribeAlarmsForMetricResponse = describeAlarmsForMetric(DescribeAlarmsForMetricRequest.Builder().apply(block).build())

/**
 * Lists the anomaly detection models that you have created in your account. For single metric anomaly detectors, you can list all of the models in your account or filter the results to only the models that are related to a certain namespace, metric name, or metric dimension. For metric math anomaly detectors, you can list them by adding `METRIC_MATH` to the `AnomalyDetectorTypes` array. This will return all metric math anomaly detectors in your account.
 */
public suspend inline fun CloudWatchClient.describeAnomalyDetectors(crossinline block: DescribeAnomalyDetectorsRequest.Builder.() -> Unit): DescribeAnomalyDetectorsResponse = describeAnomalyDetectors(DescribeAnomalyDetectorsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the Contributor Insights rules in your account.
 *
 * For more information about Contributor Insights, see [Using Contributor Insights to Analyze High-Cardinality Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
 */
public suspend inline fun CloudWatchClient.describeInsightRules(crossinline block: DescribeInsightRulesRequest.Builder.() -> Unit): DescribeInsightRulesResponse = describeInsightRules(DescribeInsightRulesRequest.Builder().apply(block).build())

/**
 * Disables the actions for the specified alarms. When an alarm's actions are disabled, the alarm actions do not execute when the alarm state changes.
 */
public suspend inline fun CloudWatchClient.disableAlarmActions(crossinline block: DisableAlarmActionsRequest.Builder.() -> Unit): DisableAlarmActionsResponse = disableAlarmActions(DisableAlarmActionsRequest.Builder().apply(block).build())

/**
 * Disables the specified Contributor Insights rules. When rules are disabled, they do not analyze log groups and do not incur costs.
 */
public suspend inline fun CloudWatchClient.disableInsightRules(crossinline block: DisableInsightRulesRequest.Builder.() -> Unit): DisableInsightRulesResponse = disableInsightRules(DisableInsightRulesRequest.Builder().apply(block).build())

/**
 * Enables the actions for the specified alarms.
 */
public suspend inline fun CloudWatchClient.enableAlarmActions(crossinline block: EnableAlarmActionsRequest.Builder.() -> Unit): EnableAlarmActionsResponse = enableAlarmActions(EnableAlarmActionsRequest.Builder().apply(block).build())

/**
 * Enables the specified Contributor Insights rules. When rules are enabled, they immediately begin analyzing log data.
 */
public suspend inline fun CloudWatchClient.enableInsightRules(crossinline block: EnableInsightRulesRequest.Builder.() -> Unit): EnableInsightRulesResponse = enableInsightRules(EnableInsightRulesRequest.Builder().apply(block).build())

/**
 * Displays the details of the dashboard that you specify.
 *
 * To copy an existing dashboard, use `GetDashboard`, and then use the data returned within `DashboardBody` as the template for the new dashboard when you call `PutDashboard` to create the copy.
 */
public suspend inline fun CloudWatchClient.getDashboard(crossinline block: GetDashboardRequest.Builder.() -> Unit): GetDashboardResponse = getDashboard(GetDashboardRequest.Builder().apply(block).build())

/**
 * This operation returns the time series data collected by a Contributor Insights rule. The data includes the identity and number of contributors to the log group.
 *
 * You can also optionally return one or more statistics about each data point in the time series. These statistics can include the following:
 * + `UniqueContributors` -- the number of unique contributors for each data point.
 * + `MaxContributorValue` -- the value of the top contributor for each data point. The identity of the contributor might change for each data point in the graph.If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the highest sum in the log field specified by the rule's `Value`, during that period.
 * + `SampleCount` -- the number of data points matched by the rule.
 * + `Sum` -- the sum of the values from all contributors during the time period represented by that data point.
 * + `Minimum` -- the minimum value from a single observation during the time period represented by that data point.
 * + `Maximum` -- the maximum value from a single observation during the time period represented by that data point.
 * + `Average` -- the average value from all contributors during the time period represented by that data point.
 */
public suspend inline fun CloudWatchClient.getInsightRuleReport(crossinline block: GetInsightRuleReportRequest.Builder.() -> Unit): GetInsightRuleReportResponse = getInsightRuleReport(GetInsightRuleReportRequest.Builder().apply(block).build())

/**
 * You can use the `GetMetricData` API to retrieve CloudWatch metric values. The operation can also include a CloudWatch Metrics Insights query, and one or more metric math functions.
 *
 * A `GetMetricData` operation that does not include a query can retrieve as many as 500 different metrics in a single request, with a total of as many as 100,800 data points. You can also optionally perform metric math expressions on the values of the returned statistics, to create new time series that represent new insights into your data. For example, using Lambda metrics, you could divide the Errors metric by the Invocations metric to get an error rate time series. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *Amazon CloudWatch User Guide*.
 *
 * If you include a Metrics Insights query, each `GetMetricData` operation can include only one query. But the same `GetMetricData` operation can also retrieve other metrics. Metrics Insights queries can query only the most recent three hours of metric data. For more information about Metrics Insights, see [Query your metrics with CloudWatch Metrics Insights](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/query_with_cloudwatch-metrics-insights.html).
 *
 * Calls to the `GetMetricData` API have a different pricing structure than calls to `GetMetricStatistics`. For more information about pricing, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
 *
 * Amazon CloudWatch retains metric data as follows:
 * + Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a `StorageResolution` of 1.
 * + Data points with a period of 60 seconds (1-minute) are available for 15 days.
 * + Data points with a period of 300 seconds (5-minute) are available for 63 days.
 * + Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).
 *
 * Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.
 *
 * If you omit `Unit` in your request, all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
 *
 * **Using Metrics Insights queries with metric math**
 *
 * You can't mix a Metric Insights query and metric math syntax in the same expression, but you can reference results from a Metrics Insights query within other Metric math expressions. A Metrics Insights query without a **GROUP BY** clause returns a single time-series (TS), and can be used as input for a metric math expression that expects a single time series. A Metrics Insights query with a **GROUP BY** clause returns an array of time-series (TS&#91;&#93;), and can be used as input for a metric math expression that expects an array of time series.
 */
public suspend inline fun CloudWatchClient.getMetricData(crossinline block: GetMetricDataRequest.Builder.() -> Unit): GetMetricDataResponse = getMetricData(GetMetricDataRequest.Builder().apply(block).build())

/**
 * Gets statistics for the specified metric.
 *
 * The maximum number of data points returned from a single call is 1,440. If you request more than 1,440 data points, CloudWatch returns an error. To reduce the number of data points, you can narrow the specified time range and make multiple requests across adjacent time ranges, or you can increase the specified period. Data points are not returned in chronological order.
 *
 * CloudWatch aggregates data points based on the length of the period that you specify. For example, if you request statistics with a one-hour period, CloudWatch aggregates all data points with time stamps that fall within each one-hour period. Therefore, the number of values aggregated by CloudWatch is larger than the number of data points returned.
 *
 * CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:
 * + The SampleCount value of the statistic set is 1.
 * + The Min and the Max values of the statistic set are equal.
 *
 * Percentile statistics are not available for metrics when any of the metric values are negative numbers.
 *
 * Amazon CloudWatch retains metric data as follows:
 * + Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a `StorageResolution` of 1.
 * + Data points with a period of 60 seconds (1-minute) are available for 15 days.
 * + Data points with a period of 300 seconds (5-minute) are available for 63 days.
 * + Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).
 *
 * Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.
 *
 * CloudWatch started retaining 5-minute and 1-hour metric data as of July 9, 2016.
 *
 * For information about metrics and dimensions supported by Amazon Web Services services, see the [Amazon CloudWatch Metrics and Dimensions Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html) in the *Amazon CloudWatch User Guide*.
 */
public suspend inline fun CloudWatchClient.getMetricStatistics(crossinline block: GetMetricStatisticsRequest.Builder.() -> Unit): GetMetricStatisticsResponse = getMetricStatistics(GetMetricStatisticsRequest.Builder().apply(block).build())

/**
 * Returns information about the metric stream that you specify.
 */
public suspend inline fun CloudWatchClient.getMetricStream(crossinline block: GetMetricStreamRequest.Builder.() -> Unit): GetMetricStreamResponse = getMetricStream(GetMetricStreamRequest.Builder().apply(block).build())

/**
 * You can use the `GetMetricWidgetImage` API to retrieve a snapshot graph of one or more Amazon CloudWatch metrics as a bitmap image. You can then embed this image into your services and products, such as wiki pages, reports, and documents. You could also retrieve images regularly, such as every minute, and create your own custom live dashboard.
 *
 * The graph you retrieve can include all CloudWatch metric graph features, including metric math and horizontal and vertical annotations.
 *
 * There is a limit of 20 transactions per second for this API. Each `GetMetricWidgetImage` action has the following limits:
 * + As many as 100 metrics in the graph.
 * + Up to 100 KB uncompressed payload.
 */
public suspend inline fun CloudWatchClient.getMetricWidgetImage(crossinline block: GetMetricWidgetImageRequest.Builder.() -> Unit): GetMetricWidgetImageResponse = getMetricWidgetImage(GetMetricWidgetImageRequest.Builder().apply(block).build())

/**
 * Returns a list of the dashboards for your account. If you include `DashboardNamePrefix`, only those dashboards with names starting with the prefix are listed. Otherwise, all dashboards in your account are listed.
 *
 * `ListDashboards` returns up to 1000 results on one page. If there are more than 1000 dashboards, you can call `ListDashboards` again and include the value you received for `NextToken` in the first call, to receive the next 1000 results.
 */
public suspend inline fun CloudWatchClient.listDashboards(crossinline block: ListDashboardsRequest.Builder.() -> Unit): ListDashboardsResponse = listDashboards(ListDashboardsRequest.Builder().apply(block).build())

/**
 * Returns a list of metric streams in this account.
 */
public suspend inline fun CloudWatchClient.listMetricStreams(crossinline block: ListMetricStreamsRequest.Builder.() -> Unit): ListMetricStreamsResponse = listMetricStreams(ListMetricStreamsRequest.Builder().apply(block).build())

/**
 * List the specified metrics. You can use the returned metrics with [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html) to obtain statistical data.
 *
 * Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with subsequent calls.
 *
 * After you create a metric, allow up to 15 minutes before the metric appears. You can see statistics about the metric sooner by using [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
 *
 * `ListMetrics` doesn't return information about metrics if those metrics haven't reported data in the past two weeks. To retrieve those metrics, use [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
 */
public suspend inline fun CloudWatchClient.listMetrics(crossinline block: ListMetricsRequest.Builder.() -> Unit): ListMetricsResponse = listMetrics(ListMetricsRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with a CloudWatch resource. Currently, alarms and Contributor Insights rules support tagging.
 */
public suspend inline fun CloudWatchClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates an anomaly detection model for a CloudWatch metric. You can use the model to display a band of expected normal values when the metric is graphed.
 *
 * For more information, see [CloudWatch Anomaly Detection](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html).
 */
public suspend inline fun CloudWatchClient.putAnomalyDetector(crossinline block: PutAnomalyDetectorRequest.Builder.() -> Unit): PutAnomalyDetectorResponse = putAnomalyDetector(PutAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Creates or updates a *composite alarm*. When you create a composite alarm, you specify a rule expression for the alarm that takes into account the alarm states of other alarms that you have created. The composite alarm goes into ALARM state only if all conditions of the rule are met.
 *
 * The alarms specified in a composite alarm's rule expression can include metric alarms and other composite alarms. The rule expression of a composite alarm can include as many as 100 underlying alarms. Any single alarm can be included in the rule expressions of as many as 150 composite alarms.
 *
 * Using composite alarms can reduce alarm noise. You can create multiple metric alarms, and also create a composite alarm and set up alerts only for the composite alarm. For example, you could create a composite alarm that goes into ALARM state only when more than one of the underlying metric alarms are in ALARM state.
 *
 * Currently, the only alarm actions that can be taken by composite alarms are notifying SNS topics.
 *
 * It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can't delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete.
 *
 * To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the `AlarmRule` of one of the alarms to `False`.
 *
 * Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path.
 *
 * When this operation creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed. For a composite alarm, this initial time after creation is the only time that the alarm can be in `INSUFFICIENT_DATA` state.
 *
 * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.
 *
 * To use this operation, you must be signed on with the `cloudwatch:PutCompositeAlarm` permission that is scoped to `*`. You can't create a composite alarms if your `cloudwatch:PutCompositeAlarm` permission has a narrower scope.
 *
 * If you are an IAM user, you must have `iam:CreateServiceLinkedRole` to create a composite alarm that has Systems Manager OpsItem actions.
 */
public suspend inline fun CloudWatchClient.putCompositeAlarm(crossinline block: PutCompositeAlarmRequest.Builder.() -> Unit): PutCompositeAlarmResponse = putCompositeAlarm(PutCompositeAlarmRequest.Builder().apply(block).build())

/**
 * Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here.
 *
 * All dashboards in your account are global, not region-specific.
 *
 * A simple way to create a dashboard using `PutDashboard` is to copy an existing dashboard. To copy an existing dashboard using the console, you can load the dashboard and then use the View/edit source command in the Actions menu to display the JSON block for that dashboard. Another way to copy a dashboard is to use `GetDashboard`, and then use the data returned within `DashboardBody` as the template for the new dashboard when you call `PutDashboard`.
 *
 * When you create a dashboard with `PutDashboard`, a good practice is to add a text widget at the top of the dashboard with a message that the dashboard was created by script and should not be changed in the console. This message could also point console users to the location of the `DashboardBody` script or the CloudFormation template used to create the dashboard.
 */
public suspend inline fun CloudWatchClient.putDashboard(crossinline block: PutDashboardRequest.Builder.() -> Unit): PutDashboardResponse = putDashboard(PutDashboardRequest.Builder().apply(block).build())

/**
 * Creates a Contributor Insights rule. Rules evaluate log events in a CloudWatch Logs log group, enabling you to find contributor data for the log events in that log group. For more information, see [Using Contributor Insights to Analyze High-Cardinality Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
 *
 * If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.
 */
public suspend inline fun CloudWatchClient.putInsightRule(crossinline block: PutInsightRuleRequest.Builder.() -> Unit): PutInsightRuleResponse = putInsightRule(PutInsightRuleRequest.Builder().apply(block).build())

/**
 * Creates or updates an alarm and associates it with the specified metric, metric math expression, or anomaly detection model.
 *
 * Alarms based on anomaly detection models cannot have Auto Scaling actions.
 *
 * When this operation creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
 *
 * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.
 *
 * If you are an IAM user, you must have Amazon EC2 permissions for some alarm operations:
 * + The `iam:CreateServiceLinkedRole` for all alarms with EC2 actions
 * + The `iam:CreateServiceLinkedRole` to create an alarm with Systems Manager OpsItem actions.
 *
 * The first time you create an alarm in the Amazon Web Services Management Console, the CLI, or by using the PutMetricAlarm API, CloudWatch creates the necessary service-linked role for you. The service-linked roles are called `AWSServiceRoleForCloudWatchEvents` and `AWSServiceRoleForCloudWatchAlarms_ActionSSM`. For more information, see [Amazon Web Services service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role).
 *
 * **Cross-account alarms**
 *
 * You can set an alarm on metrics in the current account, or in another account. To create a cross-account alarm that watches a metric in a different account, you must have completed the following pre-requisites:
 * + The account where the metrics are located (the *sharing account*) must already have a sharing role named **CloudWatch-CrossAccountSharingRole**. If it does not already have this role, you must create it using the instructions in **Set up a sharing account** in [ Cross-account cross-Region CloudWatch console](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html#enable-cross-account-cross-Region). The policy for that role must grant access to the ID of the account where you are creating the alarm.
 * + The account where you are creating the alarm (the *monitoring account*) must already have a service-linked role named **AWSServiceRoleForCloudWatchCrossAccount** to allow CloudWatch to assume the sharing role in the sharing account. If it does not, you must create it following the directions in **Set up a monitoring account** in [ Cross-account cross-Region CloudWatch console](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html#enable-cross-account-cross-Region).
 */
public suspend inline fun CloudWatchClient.putMetricAlarm(crossinline block: PutMetricAlarmRequest.Builder.() -> Unit): PutMetricAlarmResponse = putMetricAlarm(PutMetricAlarmRequest.Builder().apply(block).build())

/**
 * Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metric. If the specified metric does not exist, CloudWatch creates the metric. When CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
 *
 * You can publish either individual data points in the `Value` field, or arrays of values and the number of times each value occurred during the period by using the `Values` and `Counts` fields in the `MetricDatum` structure. Using the `Values` and `Counts` method enables you to publish up to 150 values per metric with one `PutMetricData` request, and supports retrieving percentile statistics on this data.
 *
 * Each `PutMetricData` request is limited to 40 KB in size for HTTP POST requests. You can send a payload compressed by gzip. Each request is also limited to no more than 20 different metrics.
 *
 * Although the `Value` parameter accepts numbers of type `Double`, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.
 *
 * You can use up to 10 dimensions per metric to further clarify what data the metric collects. Each dimension consists of a Name and Value pair. For more information about specifying dimensions, see [Publishing Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html) in the *Amazon CloudWatch User Guide*.
 *
 * You specify the time stamp to be associated with each data point. You can specify time stamps that are as much as two weeks before the current date, and as much as 2 hours after the current day and time.
 *
 * Data points with time stamps from 24 hours ago or longer can take at least 48 hours to become available for [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html) from the time they are submitted. Data points with time stamps between 3 and 24 hours ago can take as much as 2 hours to become available for for [GetMetricData](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html) or [GetMetricStatistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
 *
 * CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:
 * + The `SampleCount` value of the statistic set is 1 and `Min`, `Max`, and `Sum` are all equal.
 * + The `Min` and `Max` are equal, and `Sum` is equal to `Min` multiplied by `SampleCount`.
 */
public suspend inline fun CloudWatchClient.putMetricData(crossinline block: PutMetricDataRequest.Builder.() -> Unit): PutMetricDataResponse = putMetricData(PutMetricDataRequest.Builder().apply(block).build())

/**
 * Creates or updates a metric stream. Metric streams can automatically stream CloudWatch metrics to Amazon Web Services destinations including Amazon S3 and to many third-party solutions.
 *
 * For more information, see [ Using Metric Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Metric-Streams.html).
 *
 * To create a metric stream, you must be logged on to an account that has the `iam:PassRole` permission and either the `CloudWatchFullAccess` policy or the `cloudwatch:PutMetricStream` permission.
 *
 * When you create or update a metric stream, you choose one of the following:
 * + Stream metrics from all metric namespaces in the account.
 * + Stream metrics from all metric namespaces in the account, except for the namespaces that you list in `ExcludeFilters`.
 * + Stream metrics from only the metric namespaces that you list in `IncludeFilters`.
 *
 * By default, a metric stream always sends the `MAX`, `MIN`, `SUM`, and `SAMPLECOUNT` statistics for each metric that is streamed. You can use the `StatisticsConfigurations` parameter to have the metric stream also send additional statistics in the stream. Streaming additional statistics incurs additional costs. For more information, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
 *
 * When you use `PutMetricStream` to create a new metric stream, the stream is created in the `running` state. If you use it to update an existing stream, the state of the stream is not changed.
 */
public suspend inline fun CloudWatchClient.putMetricStream(crossinline block: PutMetricStreamRequest.Builder.() -> Unit): PutMetricStreamResponse = putMetricStream(PutMetricStreamRequest.Builder().apply(block).build())

/**
 * Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to `ALARM` sends an SNS message.
 *
 * Metric alarms returns to their actual state quickly, often within seconds. Because the metric alarm state change happens quickly, it is typically only visible in the alarm's **History** tab in the Amazon CloudWatch console or through [DescribeAlarmHistory](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarmHistory.html).
 *
 * If you use `SetAlarmState` on a composite alarm, the composite alarm is not guaranteed to return to its actual state. It returns to its actual state only once any of its children alarms change state. It is also reevaluated if you update its configuration.
 *
 * If an alarm triggers EC2 Auto Scaling policies or application Auto Scaling policies, you must include information in the `StateReasonData` parameter to enable the policy to take the correct action.
 */
public suspend inline fun CloudWatchClient.setAlarmState(crossinline block: SetAlarmStateRequest.Builder.() -> Unit): SetAlarmStateResponse = setAlarmState(SetAlarmStateRequest.Builder().apply(block).build())

/**
 * Starts the streaming of metrics for one or more of your metric streams.
 */
public suspend inline fun CloudWatchClient.startMetricStreams(crossinline block: StartMetricStreamsRequest.Builder.() -> Unit): StartMetricStreamsResponse = startMetricStreams(StartMetricStreamsRequest.Builder().apply(block).build())

/**
 * Stops the streaming of metrics for one or more of your metric streams.
 */
public suspend inline fun CloudWatchClient.stopMetricStreams(crossinline block: StopMetricStreamsRequest.Builder.() -> Unit): StopMetricStreamsResponse = stopMetricStreams(StopMetricStreamsRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified CloudWatch resource. Currently, the only CloudWatch resources that can be tagged are alarms and Contributor Insights rules.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
 *
 * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
 *
 * You can use the `TagResource` action with an alarm that already has tags. If you specify a new tag key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a CloudWatch resource.
 */
public suspend inline fun CloudWatchClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun CloudWatchClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
