// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Encapsulates the statistical data that CloudWatch computes from metric data.
 */
public class Datapoint private constructor(builder: Builder) {
    /**
     * The average of the metric values that correspond to the data point.
     */
    public val average: kotlin.Double? = builder.average
    /**
     * The percentile statistic for the data point.
     */
    public val extendedStatistics: Map<String, Double>? = builder.extendedStatistics
    /**
     * The maximum metric value for the data point.
     */
    public val maximum: kotlin.Double? = builder.maximum
    /**
     * The minimum metric value for the data point.
     */
    public val minimum: kotlin.Double? = builder.minimum
    /**
     * The number of metric values that contributed to the aggregate value of this data point.
     */
    public val sampleCount: kotlin.Double? = builder.sampleCount
    /**
     * The sum of the metric values for the data point.
     */
    public val sum: kotlin.Double? = builder.sum
    /**
     * The time stamp used for the data point.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The standard unit for the data point.
     */
    public val unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.Datapoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Datapoint(")
        append("average=$average,")
        append("extendedStatistics=$extendedStatistics,")
        append("maximum=$maximum,")
        append("minimum=$minimum,")
        append("sampleCount=$sampleCount,")
        append("sum=$sum,")
        append("timestamp=$timestamp,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = average?.hashCode() ?: 0
        result = 31 * result + (extendedStatistics?.hashCode() ?: 0)
        result = 31 * result + (maximum?.hashCode() ?: 0)
        result = 31 * result + (minimum?.hashCode() ?: 0)
        result = 31 * result + (sampleCount?.hashCode() ?: 0)
        result = 31 * result + (sum?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Datapoint

        if (average != other.average) return false
        if (extendedStatistics != other.extendedStatistics) return false
        if (maximum != other.maximum) return false
        if (minimum != other.minimum) return false
        if (sampleCount != other.sampleCount) return false
        if (sum != other.sum) return false
        if (timestamp != other.timestamp) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.Datapoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The average of the metric values that correspond to the data point.
         */
        public var average: kotlin.Double? = null
        /**
         * The percentile statistic for the data point.
         */
        public var extendedStatistics: Map<String, Double>? = null
        /**
         * The maximum metric value for the data point.
         */
        public var maximum: kotlin.Double? = null
        /**
         * The minimum metric value for the data point.
         */
        public var minimum: kotlin.Double? = null
        /**
         * The number of metric values that contributed to the aggregate value of this data point.
         */
        public var sampleCount: kotlin.Double? = null
        /**
         * The sum of the metric values for the data point.
         */
        public var sum: kotlin.Double? = null
        /**
         * The time stamp used for the data point.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The standard unit for the data point.
         */
        public var unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.Datapoint) : this() {
            this.average = x.average
            this.extendedStatistics = x.extendedStatistics
            this.maximum = x.maximum
            this.minimum = x.minimum
            this.sampleCount = x.sampleCount
            this.sum = x.sum
            this.timestamp = x.timestamp
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.Datapoint = Datapoint(this)
    }
}
