// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



public class DescribeAlarmsRequest private constructor(builder: Builder) {
    /**
     * Use this parameter to filter the results of the operation to only those alarms that use a certain alarm action. For example, you could specify the ARN of an SNS topic to find all alarms that send notifications to that topic.
     */
    public val actionPrefix: kotlin.String? = builder.actionPrefix
    /**
     * An alarm name prefix. If you specify this parameter, you receive information about all alarms that have names that start with this prefix.
     *
     * If this parameter is specified, you cannot specify `AlarmNames`.
     */
    public val alarmNamePrefix: kotlin.String? = builder.alarmNamePrefix
    /**
     * The names of the alarms to retrieve information about.
     */
    public val alarmNames: List<String>? = builder.alarmNames
    /**
     * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you omit this parameter, only metric alarms are returned.
     */
    public val alarmTypes: List<AlarmType>? = builder.alarmTypes
    /**
     * If you use this parameter and specify the name of a composite alarm, the operation returns information about the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms referenced in the `AlarmRule` field of the composite alarm that you specify in `ChildrenOfAlarmName`. Information about the composite alarm that you name in `ChildrenOfAlarmName` is not returned.
     *
     * If you specify `ChildrenOfAlarmName`, you cannot specify any other parameters in the request except for `MaxRecords` and `NextToken`. If you do so, you receive a validation error.
     *
     * Only the `Alarm Name`, `ARN`, `StateValue` (OK/ALARM/INSUFFICIENT_DATA), and `StateUpdatedTimestamp` information are returned by this operation when you use this parameter. To get complete information about these alarms, perform another `DescribeAlarms` operation and specify the parent alarm names in the `AlarmNames` parameter.
     */
    public val childrenOfAlarmName: kotlin.String? = builder.childrenOfAlarmName
    /**
     * The maximum number of alarm descriptions to retrieve.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The token returned by a previous call to indicate that there is more data available.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * If you use this parameter and specify the name of a metric or composite alarm, the operation returns information about the "parent" alarms of the alarm you specify. These are the composite alarms that have `AlarmRule` parameters that reference the alarm named in `ParentsOfAlarmName`. Information about the alarm that you specify in `ParentsOfAlarmName` is not returned.
     *
     * If you specify `ParentsOfAlarmName`, you cannot specify any other parameters in the request except for `MaxRecords` and `NextToken`. If you do so, you receive a validation error.
     *
     * Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete information about these alarms, perform another `DescribeAlarms` operation and specify the parent alarm names in the `AlarmNames` parameter.
     */
    public val parentsOfAlarmName: kotlin.String? = builder.parentsOfAlarmName
    /**
     * Specify this parameter to receive information only about alarms that are currently in the state that you specify.
     */
    public val stateValue: aws.sdk.kotlin.services.cloudwatch.model.StateValue? = builder.stateValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAlarmsRequest(")
        append("actionPrefix=$actionPrefix,")
        append("alarmNamePrefix=$alarmNamePrefix,")
        append("alarmNames=$alarmNames,")
        append("alarmTypes=$alarmTypes,")
        append("childrenOfAlarmName=$childrenOfAlarmName,")
        append("maxRecords=$maxRecords,")
        append("nextToken=$nextToken,")
        append("parentsOfAlarmName=$parentsOfAlarmName,")
        append("stateValue=$stateValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionPrefix?.hashCode() ?: 0
        result = 31 * result + (alarmNamePrefix?.hashCode() ?: 0)
        result = 31 * result + (alarmNames?.hashCode() ?: 0)
        result = 31 * result + (alarmTypes?.hashCode() ?: 0)
        result = 31 * result + (childrenOfAlarmName?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (parentsOfAlarmName?.hashCode() ?: 0)
        result = 31 * result + (stateValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAlarmsRequest

        if (actionPrefix != other.actionPrefix) return false
        if (alarmNamePrefix != other.alarmNamePrefix) return false
        if (alarmNames != other.alarmNames) return false
        if (alarmTypes != other.alarmTypes) return false
        if (childrenOfAlarmName != other.childrenOfAlarmName) return false
        if (maxRecords != other.maxRecords) return false
        if (nextToken != other.nextToken) return false
        if (parentsOfAlarmName != other.parentsOfAlarmName) return false
        if (stateValue != other.stateValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use this parameter to filter the results of the operation to only those alarms that use a certain alarm action. For example, you could specify the ARN of an SNS topic to find all alarms that send notifications to that topic.
         */
        public var actionPrefix: kotlin.String? = null
        /**
         * An alarm name prefix. If you specify this parameter, you receive information about all alarms that have names that start with this prefix.
         *
         * If this parameter is specified, you cannot specify `AlarmNames`.
         */
        public var alarmNamePrefix: kotlin.String? = null
        /**
         * The names of the alarms to retrieve information about.
         */
        public var alarmNames: List<String>? = null
        /**
         * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you omit this parameter, only metric alarms are returned.
         */
        public var alarmTypes: List<AlarmType>? = null
        /**
         * If you use this parameter and specify the name of a composite alarm, the operation returns information about the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms referenced in the `AlarmRule` field of the composite alarm that you specify in `ChildrenOfAlarmName`. Information about the composite alarm that you name in `ChildrenOfAlarmName` is not returned.
         *
         * If you specify `ChildrenOfAlarmName`, you cannot specify any other parameters in the request except for `MaxRecords` and `NextToken`. If you do so, you receive a validation error.
         *
         * Only the `Alarm Name`, `ARN`, `StateValue` (OK/ALARM/INSUFFICIENT_DATA), and `StateUpdatedTimestamp` information are returned by this operation when you use this parameter. To get complete information about these alarms, perform another `DescribeAlarms` operation and specify the parent alarm names in the `AlarmNames` parameter.
         */
        public var childrenOfAlarmName: kotlin.String? = null
        /**
         * The maximum number of alarm descriptions to retrieve.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The token returned by a previous call to indicate that there is more data available.
         */
        public var nextToken: kotlin.String? = null
        /**
         * If you use this parameter and specify the name of a metric or composite alarm, the operation returns information about the "parent" alarms of the alarm you specify. These are the composite alarms that have `AlarmRule` parameters that reference the alarm named in `ParentsOfAlarmName`. Information about the alarm that you specify in `ParentsOfAlarmName` is not returned.
         *
         * If you specify `ParentsOfAlarmName`, you cannot specify any other parameters in the request except for `MaxRecords` and `NextToken`. If you do so, you receive a validation error.
         *
         * Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete information about these alarms, perform another `DescribeAlarms` operation and specify the parent alarm names in the `AlarmNames` parameter.
         */
        public var parentsOfAlarmName: kotlin.String? = null
        /**
         * Specify this parameter to receive information only about alarms that are currently in the state that you specify.
         */
        public var stateValue: aws.sdk.kotlin.services.cloudwatch.model.StateValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest) : this() {
            this.actionPrefix = x.actionPrefix
            this.alarmNamePrefix = x.alarmNamePrefix
            this.alarmNames = x.alarmNames
            this.alarmTypes = x.alarmTypes
            this.childrenOfAlarmName = x.childrenOfAlarmName
            this.maxRecords = x.maxRecords
            this.nextToken = x.nextToken
            this.parentsOfAlarmName = x.parentsOfAlarmName
            this.stateValue = x.stateValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest = DescribeAlarmsRequest(this)
    }
}
