// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMetricDataRequest private constructor(builder: Builder) {
    /**
     * The time stamp indicating the latest data to be returned.
     *
     * The value specified is exclusive; results include data points up to the specified time stamp.
     *
     * For better performance, specify `StartTime` and `EndTime` values that align with the value of the metric's `Period` and sync up with the beginning and end of an hour. For example, if the `Period` of a metric is 5 minutes, specifying 12:05 or 12:30 as `EndTime` can get a faster response from CloudWatch than setting 12:07 or 12:29 as the `EndTime`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * This structure includes the `Timezone` parameter, which you can use to specify your time zone so that the labels of returned data display the correct time for your time zone.
     */
    public val labelOptions: aws.sdk.kotlin.services.cloudwatch.model.LabelOptions? = builder.labelOptions
    /**
     * The maximum number of data points the request should return before paginating. If you omit this, the default of 100,800 is used.
     */
    public val maxDatapoints: kotlin.Int? = builder.maxDatapoints
    /**
     * The metric queries to be returned. A single `GetMetricData` call can include as many as 500 `MetricDataQuery` structures. Each of these structures can specify either a metric to retrieve, a Metrics Insights query, or a math expression to perform on retrieved data.
     */
    public val metricDataQueries: List<MetricDataQuery>? = builder.metricDataQueries
    /**
     * Include this value, if it was returned by the previous `GetMetricData` operation, to get the next set of data points.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The order in which data points should be returned. `TimestampDescending` returns the newest data first and paginates when the `MaxDatapoints` limit is reached. `TimestampAscending` returns the oldest data first and paginates when the `MaxDatapoints` limit is reached.
     */
    public val scanBy: aws.sdk.kotlin.services.cloudwatch.model.ScanBy? = builder.scanBy
    /**
     * The time stamp indicating the earliest data to be returned.
     *
     * The value specified is inclusive; results include data points with the specified time stamp.
     *
     * CloudWatch rounds the specified time stamp as follows:
     * + Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down to 12:32:00.
     * + Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34 is rounded down to 12:30:00.
     * + Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is rounded down to 12:00:00.
     *
     * If you set `Period` to 5, 10, or 30, the start time of your request is rounded down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15.
     *
     * For better performance, specify `StartTime` and `EndTime` values that align with the value of the metric's `Period` and sync up with the beginning and end of an hour. For example, if the `Period` of a metric is 5 minutes, specifying 12:05 or 12:30 as `StartTime` can get a faster response from CloudWatch than setting 12:07 or 12:29 as the `StartTime`.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMetricDataRequest(")
        append("endTime=$endTime,")
        append("labelOptions=$labelOptions,")
        append("maxDatapoints=$maxDatapoints,")
        append("metricDataQueries=$metricDataQueries,")
        append("nextToken=$nextToken,")
        append("scanBy=$scanBy,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (labelOptions?.hashCode() ?: 0)
        result = 31 * result + (maxDatapoints ?: 0)
        result = 31 * result + (metricDataQueries?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scanBy?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMetricDataRequest

        if (endTime != other.endTime) return false
        if (labelOptions != other.labelOptions) return false
        if (maxDatapoints != other.maxDatapoints) return false
        if (metricDataQueries != other.metricDataQueries) return false
        if (nextToken != other.nextToken) return false
        if (scanBy != other.scanBy) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time stamp indicating the latest data to be returned.
         *
         * The value specified is exclusive; results include data points up to the specified time stamp.
         *
         * For better performance, specify `StartTime` and `EndTime` values that align with the value of the metric's `Period` and sync up with the beginning and end of an hour. For example, if the `Period` of a metric is 5 minutes, specifying 12:05 or 12:30 as `EndTime` can get a faster response from CloudWatch than setting 12:07 or 12:29 as the `EndTime`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This structure includes the `Timezone` parameter, which you can use to specify your time zone so that the labels of returned data display the correct time for your time zone.
         */
        public var labelOptions: aws.sdk.kotlin.services.cloudwatch.model.LabelOptions? = null
        /**
         * The maximum number of data points the request should return before paginating. If you omit this, the default of 100,800 is used.
         */
        public var maxDatapoints: kotlin.Int? = null
        /**
         * The metric queries to be returned. A single `GetMetricData` call can include as many as 500 `MetricDataQuery` structures. Each of these structures can specify either a metric to retrieve, a Metrics Insights query, or a math expression to perform on retrieved data.
         */
        public var metricDataQueries: List<MetricDataQuery>? = null
        /**
         * Include this value, if it was returned by the previous `GetMetricData` operation, to get the next set of data points.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The order in which data points should be returned. `TimestampDescending` returns the newest data first and paginates when the `MaxDatapoints` limit is reached. `TimestampAscending` returns the oldest data first and paginates when the `MaxDatapoints` limit is reached.
         */
        public var scanBy: aws.sdk.kotlin.services.cloudwatch.model.ScanBy? = null
        /**
         * The time stamp indicating the earliest data to be returned.
         *
         * The value specified is inclusive; results include data points with the specified time stamp.
         *
         * CloudWatch rounds the specified time stamp as follows:
         * + Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down to 12:32:00.
         * + Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34 is rounded down to 12:30:00.
         * + Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is rounded down to 12:00:00.
         *
         * If you set `Period` to 5, 10, or 30, the start time of your request is rounded down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15.
         *
         * For better performance, specify `StartTime` and `EndTime` values that align with the value of the metric's `Period` and sync up with the beginning and end of an hour. For example, if the `Period` of a metric is 5 minutes, specifying 12:05 or 12:30 as `StartTime` can get a faster response from CloudWatch than setting 12:07 or 12:29 as the `StartTime`.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.labelOptions = x.labelOptions
            this.maxDatapoints = x.maxDatapoints
            this.metricDataQueries = x.metricDataQueries
            this.nextToken = x.nextToken
            this.scanBy = x.scanBy
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataRequest = GetMetricDataRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatch.model.LabelOptions] inside the given [block]
         */
        public fun labelOptions(block: aws.sdk.kotlin.services.cloudwatch.model.LabelOptions.Builder.() -> kotlin.Unit) {
            this.labelOptions = aws.sdk.kotlin.services.cloudwatch.model.LabelOptions.invoke(block)
        }
    }
}
