// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * This structure contains the definition for a Contributor Insights rule. For more information about this rule, see[ Using Constributor Insights to analyze high-cardinality data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html) in the *Amazon CloudWatch User Guide*.
 */
public class InsightRule private constructor(builder: Builder) {
    /**
     * The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors, the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * The name of the rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * For rules that you create, this is always `{"Name": "CloudWatchLogRule", "Version": 1}`. For managed rules, this is `{"Name": "ServiceLogRule", "Version": 1}`
     */
    public val schema: kotlin.String? = builder.schema
    /**
     * Indicates whether the rule is enabled or disabled.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.InsightRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightRule(")
        append("definition=$definition,")
        append("name=$name,")
        append("schema=$schema,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightRule

        if (definition != other.definition) return false
        if (name != other.name) return false
        if (schema != other.schema) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.InsightRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors, the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
         */
        public var definition: kotlin.String? = null
        /**
         * The name of the rule.
         */
        public var name: kotlin.String? = null
        /**
         * For rules that you create, this is always `{"Name": "CloudWatchLogRule", "Version": 1}`. For managed rules, this is `{"Name": "ServiceLogRule", "Version": 1}`
         */
        public var schema: kotlin.String? = null
        /**
         * Indicates whether the rule is enabled or disabled.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.InsightRule) : this() {
            this.definition = x.definition
            this.name = x.name
            this.schema = x.schema
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.InsightRule = InsightRule(this)
    }
}
