// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * One of the unique contributors found by a Contributor Insights rule. If the rule contains multiple keys, then a unique contributor is a unique combination of values from all the keys in the rule.
 *
 * If the rule contains a single key, then each unique contributor is each unique value for this key.
 *
 * For more information, see [GetInsightRuleReport](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html).
 */
public class InsightRuleContributor private constructor(builder: Builder) {
    /**
     * An approximation of the aggregate value that comes from this contributor.
     */
    public val approximateAggregateValue: kotlin.Double? = builder.approximateAggregateValue
    /**
     * An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.
     */
    public val datapoints: List<InsightRuleContributorDatapoint>? = builder.datapoints
    /**
     * One of the log entry field keywords that is used to define contributors for this rule.
     */
    public val keys: List<String>? = builder.keys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.InsightRuleContributor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightRuleContributor(")
        append("approximateAggregateValue=$approximateAggregateValue,")
        append("datapoints=$datapoints,")
        append("keys=$keys)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approximateAggregateValue?.hashCode() ?: 0
        result = 31 * result + (datapoints?.hashCode() ?: 0)
        result = 31 * result + (keys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightRuleContributor

        if (approximateAggregateValue != other.approximateAggregateValue) return false
        if (datapoints != other.datapoints) return false
        if (keys != other.keys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.InsightRuleContributor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An approximation of the aggregate value that comes from this contributor.
         */
        public var approximateAggregateValue: kotlin.Double? = null
        /**
         * An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.
         */
        public var datapoints: List<InsightRuleContributorDatapoint>? = null
        /**
         * One of the log entry field keywords that is used to define contributors for this rule.
         */
        public var keys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.InsightRuleContributor) : this() {
            this.approximateAggregateValue = x.approximateAggregateValue
            this.datapoints = x.datapoints
            this.keys = x.keys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.InsightRuleContributor = InsightRuleContributor(this)
    }
}
