// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * One data point from the metric time series returned in a Contributor Insights rule report.
 *
 * For more information, see [GetInsightRuleReport](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html).
 */
public class InsightRuleMetricDatapoint private constructor(builder: Builder) {
    /**
     * The average value from all contributors during the time period represented by that data point.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val average: kotlin.Double? = builder.average
    /**
     * The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately, so the identity of the max contributor could be different for each timestamp.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val maxContributorValue: kotlin.Double? = builder.maxContributorValue
    /**
     * The maximum value from a single occurence from a single contributor during the time period represented by that data point.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val maximum: kotlin.Double? = builder.maximum
    /**
     * The minimum value from a single contributor during the time period represented by that data point.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val minimum: kotlin.Double? = builder.minimum
    /**
     * The number of occurrences that matched the rule during this data point.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val sampleCount: kotlin.Double? = builder.sampleCount
    /**
     * The sum of the values from all contributors during the time period represented by that data point.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val sum: kotlin.Double? = builder.sum
    /**
     * The timestamp of the data point.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The number of unique contributors who published data during this timestamp.
     *
     * This statistic is returned only if you included it in the `Metrics` array in your request.
     */
    public val uniqueContributors: kotlin.Double? = builder.uniqueContributors

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.InsightRuleMetricDatapoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightRuleMetricDatapoint(")
        append("average=$average,")
        append("maxContributorValue=$maxContributorValue,")
        append("maximum=$maximum,")
        append("minimum=$minimum,")
        append("sampleCount=$sampleCount,")
        append("sum=$sum,")
        append("timestamp=$timestamp,")
        append("uniqueContributors=$uniqueContributors)")
    }

    override fun hashCode(): kotlin.Int {
        var result = average?.hashCode() ?: 0
        result = 31 * result + (maxContributorValue?.hashCode() ?: 0)
        result = 31 * result + (maximum?.hashCode() ?: 0)
        result = 31 * result + (minimum?.hashCode() ?: 0)
        result = 31 * result + (sampleCount?.hashCode() ?: 0)
        result = 31 * result + (sum?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (uniqueContributors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightRuleMetricDatapoint

        if (average != other.average) return false
        if (maxContributorValue != other.maxContributorValue) return false
        if (maximum != other.maximum) return false
        if (minimum != other.minimum) return false
        if (sampleCount != other.sampleCount) return false
        if (sum != other.sum) return false
        if (timestamp != other.timestamp) return false
        if (uniqueContributors != other.uniqueContributors) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.InsightRuleMetricDatapoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The average value from all contributors during the time period represented by that data point.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var average: kotlin.Double? = null
        /**
         * The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately, so the identity of the max contributor could be different for each timestamp.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var maxContributorValue: kotlin.Double? = null
        /**
         * The maximum value from a single occurence from a single contributor during the time period represented by that data point.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var maximum: kotlin.Double? = null
        /**
         * The minimum value from a single contributor during the time period represented by that data point.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var minimum: kotlin.Double? = null
        /**
         * The number of occurrences that matched the rule during this data point.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var sampleCount: kotlin.Double? = null
        /**
         * The sum of the values from all contributors during the time period represented by that data point.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var sum: kotlin.Double? = null
        /**
         * The timestamp of the data point.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of unique contributors who published data during this timestamp.
         *
         * This statistic is returned only if you included it in the `Metrics` array in your request.
         */
        public var uniqueContributors: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.InsightRuleMetricDatapoint) : this() {
            this.average = x.average
            this.maxContributorValue = x.maxContributorValue
            this.maximum = x.maximum
            this.minimum = x.minimum
            this.sampleCount = x.sampleCount
            this.sum = x.sum
            this.timestamp = x.timestamp
            this.uniqueContributors = x.uniqueContributors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.InsightRuleMetricDatapoint = InsightRuleMetricDatapoint(this)
    }
}
