// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A `GetMetricData` call returns an array of `MetricDataResult` structures. Each of these structures includes the data points for that metric, along with the timestamps of those data points and other identifying information.
 */
public class MetricDataResult private constructor(builder: Builder) {
    /**
     * The short name you specified to represent this metric.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The human-readable label associated with the data.
     */
    public val label: kotlin.String? = builder.label
    /**
     * A list of messages with additional information about the data returned.
     */
    public val messages: List<MessageData>? = builder.messages
    /**
     * The status of the returned data. `Complete` indicates that all data points in the requested time range were returned. `PartialData` means that an incomplete set of data points were returned. You can use the `NextToken` value that was returned and repeat your request to get more data points. `NextToken` is not returned if you are performing a math expression. `InternalError` indicates that an error occurred. Retry your request using `NextToken`, if present.
     */
    public val statusCode: aws.sdk.kotlin.services.cloudwatch.model.StatusCode? = builder.statusCode
    /**
     * The timestamps for the data points, formatted in Unix timestamp format. The number of timestamps always matches the number of values and the value for Timestamps&#91;x&#93; is Values&#91;x&#93;.
     */
    public val timestamps: List<Instant>? = builder.timestamps
    /**
     * The data points for the metric corresponding to `Timestamps`. The number of values always matches the number of timestamps and the timestamp for Values&#91;x&#93; is Timestamps&#91;x&#93;.
     */
    public val values: List<Double>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricDataResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricDataResult(")
        append("id=$id,")
        append("label=$label,")
        append("messages=$messages,")
        append("statusCode=$statusCode,")
        append("timestamps=$timestamps,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (messages?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        result = 31 * result + (timestamps?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricDataResult

        if (id != other.id) return false
        if (label != other.label) return false
        if (messages != other.messages) return false
        if (statusCode != other.statusCode) return false
        if (timestamps != other.timestamps) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricDataResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The short name you specified to represent this metric.
         */
        public var id: kotlin.String? = null
        /**
         * The human-readable label associated with the data.
         */
        public var label: kotlin.String? = null
        /**
         * A list of messages with additional information about the data returned.
         */
        public var messages: List<MessageData>? = null
        /**
         * The status of the returned data. `Complete` indicates that all data points in the requested time range were returned. `PartialData` means that an incomplete set of data points were returned. You can use the `NextToken` value that was returned and repeat your request to get more data points. `NextToken` is not returned if you are performing a math expression. `InternalError` indicates that an error occurred. Retry your request using `NextToken`, if present.
         */
        public var statusCode: aws.sdk.kotlin.services.cloudwatch.model.StatusCode? = null
        /**
         * The timestamps for the data points, formatted in Unix timestamp format. The number of timestamps always matches the number of values and the value for Timestamps&#91;x&#93; is Values&#91;x&#93;.
         */
        public var timestamps: List<Instant>? = null
        /**
         * The data points for the metric corresponding to `Timestamps`. The number of values always matches the number of timestamps and the timestamp for Values&#91;x&#93; is Timestamps&#91;x&#93;.
         */
        public var values: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricDataResult) : this() {
            this.id = x.id
            this.label = x.label
            this.messages = x.messages
            this.statusCode = x.statusCode
            this.timestamps = x.timestamps
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricDataResult = MetricDataResult(this)
    }
}
