// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Encapsulates the information sent to either create a metric or add new values to be aggregated into an existing metric.
 */
public class MetricDatum private constructor(builder: Builder) {
    /**
     * Array of numbers that is used along with the `Values` array. Each number in the `Count` array is the number of times the corresponding value in the `Values` array occurred during the period.
     *
     * If you omit the `Counts` array, the default of 1 is used as the value for each count. If you include a `Counts` array, it must include the same amount of values as the `Values` array.
     */
    public val counts: List<Double>? = builder.counts
    /**
     * The dimensions associated with the metric.
     */
    public val dimensions: List<Dimension>? = builder.dimensions
    /**
     * The name of the metric.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * The statistical values for the metric.
     */
    public val statisticValues: aws.sdk.kotlin.services.cloudwatch.model.StatisticSet? = builder.statisticValues
    /**
     * Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with sub-minute resolution down to one second. Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available only for custom metrics. For more information about high-resolution metrics, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide*.
     *
     * This field is optional, if you do not specify it the default of 60 is used.
     */
    public val storageResolution: kotlin.Int? = builder.storageResolution
    /**
     * The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * When you are using a `Put` operation, this defines what unit you want to use when storing the metric.
     *
     * In a `Get` operation, this displays the unit that is used for the metric.
     */
    public val unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = builder.unit
    /**
     * The value for the metric.
     *
     * Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.
     */
    public val value: kotlin.Double? = builder.value
    /**
     * Array of numbers representing the values for the metric during the period. Each unique value is listed just once in this array, and the corresponding number in the `Counts` array specifies the number of times that value occurred during the period. You can include up to 150 unique values in each `PutMetricData` action that specifies a `Values` array.
     *
     * Although the `Values` array accepts numbers of type `Double`, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.
     */
    public val values: List<Double>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricDatum = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricDatum(")
        append("counts=$counts,")
        append("dimensions=$dimensions,")
        append("metricName=$metricName,")
        append("statisticValues=$statisticValues,")
        append("storageResolution=$storageResolution,")
        append("timestamp=$timestamp,")
        append("unit=$unit,")
        append("value=$value,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = counts?.hashCode() ?: 0
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (statisticValues?.hashCode() ?: 0)
        result = 31 * result + (storageResolution ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricDatum

        if (counts != other.counts) return false
        if (dimensions != other.dimensions) return false
        if (metricName != other.metricName) return false
        if (statisticValues != other.statisticValues) return false
        if (storageResolution != other.storageResolution) return false
        if (timestamp != other.timestamp) return false
        if (unit != other.unit) return false
        if (value != other.value) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricDatum = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Array of numbers that is used along with the `Values` array. Each number in the `Count` array is the number of times the corresponding value in the `Values` array occurred during the period.
         *
         * If you omit the `Counts` array, the default of 1 is used as the value for each count. If you include a `Counts` array, it must include the same amount of values as the `Values` array.
         */
        public var counts: List<Double>? = null
        /**
         * The dimensions associated with the metric.
         */
        public var dimensions: List<Dimension>? = null
        /**
         * The name of the metric.
         */
        public var metricName: kotlin.String? = null
        /**
         * The statistical values for the metric.
         */
        public var statisticValues: aws.sdk.kotlin.services.cloudwatch.model.StatisticSet? = null
        /**
         * Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with sub-minute resolution down to one second. Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available only for custom metrics. For more information about high-resolution metrics, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide*.
         *
         * This field is optional, if you do not specify it the default of 60 is used.
         */
        public var storageResolution: kotlin.Int? = null
        /**
         * The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When you are using a `Put` operation, this defines what unit you want to use when storing the metric.
         *
         * In a `Get` operation, this displays the unit that is used for the metric.
         */
        public var unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = null
        /**
         * The value for the metric.
         *
         * Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.
         */
        public var value: kotlin.Double? = null
        /**
         * Array of numbers representing the values for the metric during the period. Each unique value is listed just once in this array, and the corresponding number in the `Counts` array specifies the number of times that value occurred during the period. You can include up to 150 unique values in each `PutMetricData` action that specifies a `Values` array.
         *
         * Although the `Values` array accepts numbers of type `Double`, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.
         */
        public var values: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricDatum) : this() {
            this.counts = x.counts
            this.dimensions = x.dimensions
            this.metricName = x.metricName
            this.statisticValues = x.statisticValues
            this.storageResolution = x.storageResolution
            this.timestamp = x.timestamp
            this.unit = x.unit
            this.value = x.value
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricDatum = MetricDatum(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatch.model.StatisticSet] inside the given [block]
         */
        public fun statisticValues(block: aws.sdk.kotlin.services.cloudwatch.model.StatisticSet.Builder.() -> kotlin.Unit) {
            this.statisticValues = aws.sdk.kotlin.services.cloudwatch.model.StatisticSet.invoke(block)
        }
    }
}
