// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This structure contains the configuration information about one metric stream.
 */
public class MetricStreamEntry private constructor(builder: Builder) {
    /**
     * The ARN of the metric stream.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date that the metric stream was originally created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.
     */
    public val firehoseArn: kotlin.String? = builder.firehoseArn
    /**
     * The date that the configuration of this metric stream was most recently updated.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateDate
    /**
     * The name of the metric stream.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The output format of this metric stream. Valid values are `json` and `opentelemetry0.7`.
     */
    public val outputFormat: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat? = builder.outputFormat
    /**
     * The current state of this stream. Valid values are `running` and `stopped`.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricStreamEntry(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("firehoseArn=$firehoseArn,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("outputFormat=$outputFormat,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (firehoseArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricStreamEntry

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (firehoseArn != other.firehoseArn) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (outputFormat != other.outputFormat) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the metric stream.
         */
        public var arn: kotlin.String? = null
        /**
         * The date that the metric stream was originally created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.
         */
        public var firehoseArn: kotlin.String? = null
        /**
         * The date that the configuration of this metric stream was most recently updated.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the metric stream.
         */
        public var name: kotlin.String? = null
        /**
         * The output format of this metric stream. Valid values are `json` and `opentelemetry0.7`.
         */
        public var outputFormat: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat? = null
        /**
         * The current state of this stream. Valid values are `running` and `stopped`.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamEntry) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.firehoseArn = x.firehoseArn
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.outputFormat = x.outputFormat
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamEntry = MetricStreamEntry(this)
    }
}
