// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



public class PutCompositeAlarmRequest private constructor(builder: Builder) {
    /**
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. The default is `TRUE`.
     */
    public val actionsEnabled: kotlin.Boolean? = builder.actionsEnabled
    /**
     * Actions will be suppressed if the suppressor alarm is in the `ALARM` state. `ActionsSuppressor` can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
     */
    public val actionsSuppressor: kotlin.String? = builder.actionsSuppressor
    /**
     * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
     *
     * `ExtensionPeriod` is required only when `ActionsSuppressor` is specified.
     */
    public val actionsSuppressorExtensionPeriod: kotlin.Int? = builder.actionsSuppressorExtensionPeriod
    /**
     * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
     *
     * `WaitPeriod` is required only when `ActionsSuppressor` is specified.
     */
    public val actionsSuppressorWaitPeriod: kotlin.Int? = builder.actionsSuppressorWaitPeriod
    /**
     * The actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     *
     * Valid Values: `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> `
     */
    public val alarmActions: List<String>? = builder.alarmActions
    /**
     * The description for the composite alarm.
     */
    public val alarmDescription: kotlin.String? = builder.alarmDescription
    /**
     * The name for the composite alarm. This name must be unique within the Region.
     */
    public val alarmName: kotlin.String? = builder.alarmName
    /**
     * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically group the functions in your expression.
     *
     * You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
     *
     * Functions can include the following:
     * + `ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")` is TRUE if the named alarm is in ALARM state.
     * + `OK("<i>alarm-name</i> or <i>alarm-ARN</i>")` is TRUE if the named alarm is in OK state.
     * + `INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")` is TRUE if the named alarm is in INSUFFICIENT_DATA state.
     * + `TRUE` always evaluates to TRUE.
     * + `FALSE` always evaluates to FALSE.
     *
     * TRUE and FALSE are useful for testing a complex `AlarmRule` structure, and for testing your alarm actions.
     *
     * Alarm names specified in `AlarmRule` can be surrounded with double-quotes ("), but do not have to be.
     *
     * The following are some examples of `AlarmRule`:
     * + `ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)` specifies that the composite alarm goes into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in ALARM state.
     * + `ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)` specifies that the alarm goes to ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in ALARM state. This example reduces alarm noise during a known deployment window.
     * + `(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)` goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if NetworkOutTooHigh is in OK state. This provides another example of using a composite alarm to prevent noise. This rule ensures that you are not notified with an alarm action on high CPU or disk usage if a known network problem is also occurring.
     *
     * The `AlarmRule` can specify as many as 100 "children" alarms. The `AlarmRule` expression can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and parentheses.
     */
    public val alarmRule: kotlin.String? = builder.alarmRule
    /**
     * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     *
     * Valid Values: `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> `
     */
    public val insufficientDataActions: List<String>? = builder.insufficientDataActions
    /**
     * The actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     *
     * Valid Values: `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> `
     */
    public val okActions: List<String>? = builder.okActions
    /**
     * A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an alarm.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.PutCompositeAlarmRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutCompositeAlarmRequest(")
        append("actionsEnabled=$actionsEnabled,")
        append("actionsSuppressor=$actionsSuppressor,")
        append("actionsSuppressorExtensionPeriod=$actionsSuppressorExtensionPeriod,")
        append("actionsSuppressorWaitPeriod=$actionsSuppressorWaitPeriod,")
        append("alarmActions=$alarmActions,")
        append("alarmDescription=$alarmDescription,")
        append("alarmName=$alarmName,")
        append("alarmRule=$alarmRule,")
        append("insufficientDataActions=$insufficientDataActions,")
        append("okActions=$okActions,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsEnabled?.hashCode() ?: 0
        result = 31 * result + (actionsSuppressor?.hashCode() ?: 0)
        result = 31 * result + (actionsSuppressorExtensionPeriod ?: 0)
        result = 31 * result + (actionsSuppressorWaitPeriod ?: 0)
        result = 31 * result + (alarmActions?.hashCode() ?: 0)
        result = 31 * result + (alarmDescription?.hashCode() ?: 0)
        result = 31 * result + (alarmName?.hashCode() ?: 0)
        result = 31 * result + (alarmRule?.hashCode() ?: 0)
        result = 31 * result + (insufficientDataActions?.hashCode() ?: 0)
        result = 31 * result + (okActions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutCompositeAlarmRequest

        if (actionsEnabled != other.actionsEnabled) return false
        if (actionsSuppressor != other.actionsSuppressor) return false
        if (actionsSuppressorExtensionPeriod != other.actionsSuppressorExtensionPeriod) return false
        if (actionsSuppressorWaitPeriod != other.actionsSuppressorWaitPeriod) return false
        if (alarmActions != other.alarmActions) return false
        if (alarmDescription != other.alarmDescription) return false
        if (alarmName != other.alarmName) return false
        if (alarmRule != other.alarmRule) return false
        if (insufficientDataActions != other.insufficientDataActions) return false
        if (okActions != other.okActions) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.PutCompositeAlarmRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. The default is `TRUE`.
         */
        public var actionsEnabled: kotlin.Boolean? = null
        /**
         * Actions will be suppressed if the suppressor alarm is in the `ALARM` state. `ActionsSuppressor` can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
         */
        public var actionsSuppressor: kotlin.String? = null
        /**
         * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
         *
         * `ExtensionPeriod` is required only when `ActionsSuppressor` is specified.
         */
        public var actionsSuppressorExtensionPeriod: kotlin.Int? = null
        /**
         * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
         *
         * `WaitPeriod` is required only when `ActionsSuppressor` is specified.
         */
        public var actionsSuppressorWaitPeriod: kotlin.Int? = null
        /**
         * The actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         *
         * Valid Values: `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> `
         */
        public var alarmActions: List<String>? = null
        /**
         * The description for the composite alarm.
         */
        public var alarmDescription: kotlin.String? = null
        /**
         * The name for the composite alarm. This name must be unique within the Region.
         */
        public var alarmName: kotlin.String? = null
        /**
         * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically group the functions in your expression.
         *
         * You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
         *
         * Functions can include the following:
         * + `ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")` is TRUE if the named alarm is in ALARM state.
         * + `OK("<i>alarm-name</i> or <i>alarm-ARN</i>")` is TRUE if the named alarm is in OK state.
         * + `INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")` is TRUE if the named alarm is in INSUFFICIENT_DATA state.
         * + `TRUE` always evaluates to TRUE.
         * + `FALSE` always evaluates to FALSE.
         *
         * TRUE and FALSE are useful for testing a complex `AlarmRule` structure, and for testing your alarm actions.
         *
         * Alarm names specified in `AlarmRule` can be surrounded with double-quotes ("), but do not have to be.
         *
         * The following are some examples of `AlarmRule`:
         * + `ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)` specifies that the composite alarm goes into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in ALARM state.
         * + `ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)` specifies that the alarm goes to ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in ALARM state. This example reduces alarm noise during a known deployment window.
         * + `(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)` goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if NetworkOutTooHigh is in OK state. This provides another example of using a composite alarm to prevent noise. This rule ensures that you are not notified with an alarm action on high CPU or disk usage if a known network problem is also occurring.
         *
         * The `AlarmRule` can specify as many as 100 "children" alarms. The `AlarmRule` expression can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and parentheses.
         */
        public var alarmRule: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         *
         * Valid Values: `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> `
         */
        public var insufficientDataActions: List<String>? = null
        /**
         * The actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         *
         * Valid Values: `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> `
         */
        public var okActions: List<String>? = null
        /**
         * A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an alarm.
         *
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.PutCompositeAlarmRequest) : this() {
            this.actionsEnabled = x.actionsEnabled
            this.actionsSuppressor = x.actionsSuppressor
            this.actionsSuppressorExtensionPeriod = x.actionsSuppressorExtensionPeriod
            this.actionsSuppressorWaitPeriod = x.actionsSuppressorWaitPeriod
            this.alarmActions = x.alarmActions
            this.alarmDescription = x.alarmDescription
            this.alarmName = x.alarmName
            this.alarmRule = x.alarmRule
            this.insufficientDataActions = x.insufficientDataActions
            this.okActions = x.okActions
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.PutCompositeAlarmRequest = PutCompositeAlarmRequest(this)
    }
}
