// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



public class PutInsightRuleRequest private constructor(builder: Builder) {
    /**
     * The definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
     */
    public val ruleDefinition: kotlin.String? = builder.ruleDefinition
    /**
     * A unique name for the rule.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * The state of the rule. Valid values are ENABLED and DISABLED.
     */
    public val ruleState: kotlin.String? = builder.ruleState
    /**
     * A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50 tags with a rule.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values.
     *
     * To be able to associate tags with a rule, you must have the `cloudwatch:TagResource` permission in addition to the `cloudwatch:PutInsightRule` permission.
     *
     * If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this parameter are ignored. To change the tags of an existing rule, use [TagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.PutInsightRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutInsightRuleRequest(")
        append("ruleDefinition=$ruleDefinition,")
        append("ruleName=$ruleName,")
        append("ruleState=$ruleState,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ruleDefinition?.hashCode() ?: 0
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (ruleState?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutInsightRuleRequest

        if (ruleDefinition != other.ruleDefinition) return false
        if (ruleName != other.ruleName) return false
        if (ruleState != other.ruleState) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.PutInsightRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
         */
        public var ruleDefinition: kotlin.String? = null
        /**
         * A unique name for the rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * The state of the rule. Valid values are ENABLED and DISABLED.
         */
        public var ruleState: kotlin.String? = null
        /**
         * A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50 tags with a rule.
         *
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values.
         *
         * To be able to associate tags with a rule, you must have the `cloudwatch:TagResource` permission in addition to the `cloudwatch:PutInsightRule` permission.
         *
         * If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this parameter are ignored. To change the tags of an existing rule, use [TagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.PutInsightRuleRequest) : this() {
            this.ruleDefinition = x.ruleDefinition
            this.ruleName = x.ruleName
            this.ruleState = x.ruleState
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.PutInsightRuleRequest = PutInsightRuleRequest(this)
    }
}
