// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



public class PutMetricAlarmRequest private constructor(builder: Builder) {
    /**
     * Indicates whether actions should be executed during any changes to the alarm state. The default is `TRUE`.
     */
    public val actionsEnabled: kotlin.Boolean? = builder.actionsEnabled
    /**
     * The actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     *
     * Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` | `arn:aws:automate:<i>region</i>:ec2:terminate` | `arn:aws:automate:<i>region</i>:ec2:recover` | `arn:aws:automate:<i>region</i>:ec2:reboot` | `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> ` | `arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> ` | `arn:aws:ssm-incidents::<i>account-id</i>:response-plan:<i>response-plan-name</i> `
     *
     * Valid Values (for use with IAM roles): `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Recover/1.0`
     */
    public val alarmActions: List<String>? = builder.alarmActions
    /**
     * The description for the alarm.
     */
    public val alarmDescription: kotlin.String? = builder.alarmDescription
    /**
     * The name for the alarm. This name must be unique within the Region.
     */
    public val alarmName: kotlin.String? = builder.alarmName
    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
     *
     * The values `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.cloudwatch.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * The number of data points that must be breaching to trigger the alarm. This is used only if you are setting an "M out of N" alarm. In that case, this value is the M. For more information, see [Evaluating an Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation) in the *Amazon CloudWatch User Guide*.
     */
    public val datapointsToAlarm: kotlin.Int? = builder.datapointsToAlarm
    /**
     * The dimensions for the metric specified in `MetricName`.
     */
    public val dimensions: List<Dimension>? = builder.dimensions
    /**
     * Used only for alarms based on percentiles. If you specify `ignore`, the alarm state does not change during periods with too few data points to be statistically significant. If you specify `evaluate` or omit this parameter, the alarm is always evaluated and possibly changes state no matter how many data points are available. For more information, see [Percentile-Based CloudWatch Alarms and Low Data Samples](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
     *
     * Valid Values: `evaluate | ignore`
     */
    public val evaluateLowSampleCountPercentile: kotlin.String? = builder.evaluateLowSampleCountPercentile
    /**
     * The number of periods over which data is compared to the specified threshold. If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies that number. If you are setting an "M out of N" alarm, this value is the N.
     *
     * An alarm's total current evaluation period can be no longer than one day, so this number multiplied by `Period` cannot be more than 86,400 seconds.
     */
    public val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * The percentile statistic for the metric specified in `MetricName`. Specify a value between p0.0 and p100. When you call `PutMetricAlarm` and specify a `MetricName`, you must specify either `Statistic` or `ExtendedStatistic,` but not both.
     */
    public val extendedStatistic: kotlin.String? = builder.extendedStatistic
    /**
     * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     *
     * Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` | `arn:aws:automate:<i>region</i>:ec2:terminate` | `arn:aws:automate:<i>region</i>:ec2:recover` | `arn:aws:automate:<i>region</i>:ec2:reboot` | `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
     *
     * Valid Values (for use with IAM roles): `>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
     */
    public val insufficientDataActions: List<String>? = builder.insufficientDataActions
    /**
     * The name for the metric associated with the alarm. For each `PutMetricAlarm` operation, you must specify either `MetricName` or a `Metrics` array.
     *
     * If you are creating an alarm based on a math expression, you cannot specify this parameter, or any of the `Dimensions`, `Period`, `Namespace`, `Statistic`, or `ExtendedStatistic` parameters. Instead, you specify all this information in the `Metrics` array.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * An array of `MetricDataQuery` structures that enable you to create an alarm based on the result of a metric math expression. For each `PutMetricAlarm` operation, you must specify either `MetricName` or a `Metrics` array.
     *
     * Each item in the `Metrics` array either retrieves a metric or performs a math expression.
     *
     * One item in the `Metrics` array is the expression that the alarm watches. You designate this expression by setting `ReturnData` to true for this object in the array. For more information, see [MetricDataQuery](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDataQuery.html).
     *
     * If you use the `Metrics` parameter, you cannot include the `MetricName`, `Dimensions`, `Period`, `Namespace`, `Statistic`, or `ExtendedStatistic` parameters of `PutMetricAlarm` in the same operation. Instead, you retrieve the metrics you are using in your math expression as part of the `Metrics` array.
     */
    public val metrics: List<MetricDataQuery>? = builder.metrics
    /**
     * The namespace for the metric associated specified in `MetricName`.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     *
     * Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` | `arn:aws:automate:<i>region</i>:ec2:terminate` | `arn:aws:automate:<i>region</i>:ec2:recover` | `arn:aws:automate:<i>region</i>:ec2:reboot` | `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
     *
     * Valid Values (for use with IAM roles): `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Recover/1.0`
     */
    public val okActions: List<String>? = builder.okActions
    /**
     * The length, in seconds, used each time the metric specified in `MetricName` is evaluated. Valid values are 10, 30, and any multiple of 60.
     *
     * `Period` is required for alarms based on static thresholds. If you are creating an alarm based on a metric math expression, you specify the period for each metric within the objects in the `Metrics` array.
     *
     * Be sure to specify 10 or 30 only for metrics that are stored by a `PutMetricData` call with a `StorageResolution` of 1. If you specify a period of 10 or 30 for a metric that does not have sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In this case, it does not receive data for the attempts that do not correspond to a one-minute data resolution, and the alarm might often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a high-resolution alarm, which has a higher charge than other alarms. For more information about pricing, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
     *
     * An alarm's total current evaluation period can be no longer than one day, so `Period` multiplied by `EvaluationPeriods` cannot be more than 86,400 seconds.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The statistic for the metric specified in `MetricName`, other than percentile. For percentile statistics, use `ExtendedStatistic`. When you call `PutMetricAlarm` and specify a `MetricName`, you must specify either `Statistic` or `ExtendedStatistic,` but not both.
     */
    public val statistic: aws.sdk.kotlin.services.cloudwatch.model.Statistic? = builder.statistic
    /**
     * A list of key-value pairs to associate with the alarm. You can associate as many as 50 tags with an alarm.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     *
     * If you are using this operation to update an existing alarm, any tags you specify in this parameter are ignored. To change the tags of an existing alarm, use [TagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html) or [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The value against which the specified statistic is compared.
     *
     * This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
     */
    public val threshold: kotlin.Double? = builder.threshold
    /**
     * If this is an alarm based on an anomaly detection model, make this value match the ID of the `ANOMALY_DETECTION_BAND` function.
     *
     * For an example of how to use this parameter, see the **Anomaly Detection Model Alarm** example on this page.
     *
     * If your alarm uses this parameter, it cannot have Auto Scaling actions.
     */
    public val thresholdMetricId: kotlin.String? = builder.thresholdMetricId
    /**
     * Sets how this alarm is to handle missing data points. If `TreatMissingData` is omitted, the default behavior of `missing` is used. For more information, see [Configuring How CloudWatch Alarms Treats Missing Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
     *
     * Valid Values: `breaching | notBreaching | ignore | missing`
     *
     * Alarms that evaluate metrics in the `AWS/DynamoDB` namespace always `ignore` missing data even if you choose a different option for `TreatMissingData`. When an `AWS/DynamoDB` metric has missing data, alarms that evaluate that metric remain in their current state.
     */
    public val treatMissingData: kotlin.String? = builder.treatMissingData
    /**
     * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data points that specify a unit of measure, such as Percent, are aggregated separately.
     *
     * If you don't specify `Unit`, CloudWatch retrieves all unit types that have been published for the metric and attempts to evaluate the alarm. Usually, metrics are published with only one unit, so the alarm works as intended.
     *
     * However, if the metric is published with multiple types of units and you don't specify a unit, the alarm's behavior is not defined and it behaves predictably.
     *
     * We recommend omitting `Unit` so that you don't inadvertently specify an incorrect unit that is not published for this metric. Doing so causes the alarm to be stuck in the `INSUFFICIENT DATA` state.
     */
    public val unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutMetricAlarmRequest(")
        append("actionsEnabled=$actionsEnabled,")
        append("alarmActions=$alarmActions,")
        append("alarmDescription=$alarmDescription,")
        append("alarmName=$alarmName,")
        append("comparisonOperator=$comparisonOperator,")
        append("datapointsToAlarm=$datapointsToAlarm,")
        append("dimensions=$dimensions,")
        append("evaluateLowSampleCountPercentile=$evaluateLowSampleCountPercentile,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("extendedStatistic=$extendedStatistic,")
        append("insufficientDataActions=$insufficientDataActions,")
        append("metricName=$metricName,")
        append("metrics=$metrics,")
        append("namespace=$namespace,")
        append("okActions=$okActions,")
        append("period=$period,")
        append("statistic=$statistic,")
        append("tags=$tags,")
        append("threshold=$threshold,")
        append("thresholdMetricId=$thresholdMetricId,")
        append("treatMissingData=$treatMissingData,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsEnabled?.hashCode() ?: 0
        result = 31 * result + (alarmActions?.hashCode() ?: 0)
        result = 31 * result + (alarmDescription?.hashCode() ?: 0)
        result = 31 * result + (alarmName?.hashCode() ?: 0)
        result = 31 * result + (comparisonOperator?.hashCode() ?: 0)
        result = 31 * result + (datapointsToAlarm ?: 0)
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (evaluateLowSampleCountPercentile?.hashCode() ?: 0)
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (extendedStatistic?.hashCode() ?: 0)
        result = 31 * result + (insufficientDataActions?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (okActions?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        result = 31 * result + (thresholdMetricId?.hashCode() ?: 0)
        result = 31 * result + (treatMissingData?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutMetricAlarmRequest

        if (actionsEnabled != other.actionsEnabled) return false
        if (alarmActions != other.alarmActions) return false
        if (alarmDescription != other.alarmDescription) return false
        if (alarmName != other.alarmName) return false
        if (comparisonOperator != other.comparisonOperator) return false
        if (datapointsToAlarm != other.datapointsToAlarm) return false
        if (dimensions != other.dimensions) return false
        if (evaluateLowSampleCountPercentile != other.evaluateLowSampleCountPercentile) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (extendedStatistic != other.extendedStatistic) return false
        if (insufficientDataActions != other.insufficientDataActions) return false
        if (metricName != other.metricName) return false
        if (metrics != other.metrics) return false
        if (namespace != other.namespace) return false
        if (okActions != other.okActions) return false
        if (period != other.period) return false
        if (statistic != other.statistic) return false
        if (tags != other.tags) return false
        if (threshold != other.threshold) return false
        if (thresholdMetricId != other.thresholdMetricId) return false
        if (treatMissingData != other.treatMissingData) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether actions should be executed during any changes to the alarm state. The default is `TRUE`.
         */
        public var actionsEnabled: kotlin.Boolean? = null
        /**
         * The actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         *
         * Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` | `arn:aws:automate:<i>region</i>:ec2:terminate` | `arn:aws:automate:<i>region</i>:ec2:recover` | `arn:aws:automate:<i>region</i>:ec2:reboot` | `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> ` | `arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> ` | `arn:aws:ssm-incidents::<i>account-id</i>:response-plan:<i>response-plan-name</i> `
         *
         * Valid Values (for use with IAM roles): `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Recover/1.0`
         */
        public var alarmActions: List<String>? = null
        /**
         * The description for the alarm.
         */
        public var alarmDescription: kotlin.String? = null
        /**
         * The name for the alarm. This name must be unique within the Region.
         */
        public var alarmName: kotlin.String? = null
        /**
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
         *
         * The values `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.cloudwatch.model.ComparisonOperator? = null
        /**
         * The number of data points that must be breaching to trigger the alarm. This is used only if you are setting an "M out of N" alarm. In that case, this value is the M. For more information, see [Evaluating an Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation) in the *Amazon CloudWatch User Guide*.
         */
        public var datapointsToAlarm: kotlin.Int? = null
        /**
         * The dimensions for the metric specified in `MetricName`.
         */
        public var dimensions: List<Dimension>? = null
        /**
         * Used only for alarms based on percentiles. If you specify `ignore`, the alarm state does not change during periods with too few data points to be statistically significant. If you specify `evaluate` or omit this parameter, the alarm is always evaluated and possibly changes state no matter how many data points are available. For more information, see [Percentile-Based CloudWatch Alarms and Low Data Samples](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
         *
         * Valid Values: `evaluate | ignore`
         */
        public var evaluateLowSampleCountPercentile: kotlin.String? = null
        /**
         * The number of periods over which data is compared to the specified threshold. If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies that number. If you are setting an "M out of N" alarm, this value is the N.
         *
         * An alarm's total current evaluation period can be no longer than one day, so this number multiplied by `Period` cannot be more than 86,400 seconds.
         */
        public var evaluationPeriods: kotlin.Int? = null
        /**
         * The percentile statistic for the metric specified in `MetricName`. Specify a value between p0.0 and p100. When you call `PutMetricAlarm` and specify a `MetricName`, you must specify either `Statistic` or `ExtendedStatistic,` but not both.
         */
        public var extendedStatistic: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         *
         * Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` | `arn:aws:automate:<i>region</i>:ec2:terminate` | `arn:aws:automate:<i>region</i>:ec2:recover` | `arn:aws:automate:<i>region</i>:ec2:reboot` | `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
         *
         * Valid Values (for use with IAM roles): `>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
         */
        public var insufficientDataActions: List<String>? = null
        /**
         * The name for the metric associated with the alarm. For each `PutMetricAlarm` operation, you must specify either `MetricName` or a `Metrics` array.
         *
         * If you are creating an alarm based on a math expression, you cannot specify this parameter, or any of the `Dimensions`, `Period`, `Namespace`, `Statistic`, or `ExtendedStatistic` parameters. Instead, you specify all this information in the `Metrics` array.
         */
        public var metricName: kotlin.String? = null
        /**
         * An array of `MetricDataQuery` structures that enable you to create an alarm based on the result of a metric math expression. For each `PutMetricAlarm` operation, you must specify either `MetricName` or a `Metrics` array.
         *
         * Each item in the `Metrics` array either retrieves a metric or performs a math expression.
         *
         * One item in the `Metrics` array is the expression that the alarm watches. You designate this expression by setting `ReturnData` to true for this object in the array. For more information, see [MetricDataQuery](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDataQuery.html).
         *
         * If you use the `Metrics` parameter, you cannot include the `MetricName`, `Dimensions`, `Period`, `Namespace`, `Statistic`, or `ExtendedStatistic` parameters of `PutMetricAlarm` in the same operation. Instead, you retrieve the metrics you are using in your math expression as part of the `Metrics` array.
         */
        public var metrics: List<MetricDataQuery>? = null
        /**
         * The namespace for the metric associated specified in `MetricName`.
         */
        public var namespace: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         *
         * Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` | `arn:aws:automate:<i>region</i>:ec2:terminate` | `arn:aws:automate:<i>region</i>:ec2:recover` | `arn:aws:automate:<i>region</i>:ec2:reboot` | `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` | `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
         *
         * Valid Values (for use with IAM roles): `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0` | `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Recover/1.0`
         */
        public var okActions: List<String>? = null
        /**
         * The length, in seconds, used each time the metric specified in `MetricName` is evaluated. Valid values are 10, 30, and any multiple of 60.
         *
         * `Period` is required for alarms based on static thresholds. If you are creating an alarm based on a metric math expression, you specify the period for each metric within the objects in the `Metrics` array.
         *
         * Be sure to specify 10 or 30 only for metrics that are stored by a `PutMetricData` call with a `StorageResolution` of 1. If you specify a period of 10 or 30 for a metric that does not have sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In this case, it does not receive data for the attempts that do not correspond to a one-minute data resolution, and the alarm might often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a high-resolution alarm, which has a higher charge than other alarms. For more information about pricing, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
         *
         * An alarm's total current evaluation period can be no longer than one day, so `Period` multiplied by `EvaluationPeriods` cannot be more than 86,400 seconds.
         */
        public var period: kotlin.Int? = null
        /**
         * The statistic for the metric specified in `MetricName`, other than percentile. For percentile statistics, use `ExtendedStatistic`. When you call `PutMetricAlarm` and specify a `MetricName`, you must specify either `Statistic` or `ExtendedStatistic,` but not both.
         */
        public var statistic: aws.sdk.kotlin.services.cloudwatch.model.Statistic? = null
        /**
         * A list of key-value pairs to associate with the alarm. You can associate as many as 50 tags with an alarm.
         *
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *
         * If you are using this operation to update an existing alarm, any tags you specify in this parameter are ignored. To change the tags of an existing alarm, use [TagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html) or [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The value against which the specified statistic is compared.
         *
         * This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
         */
        public var threshold: kotlin.Double? = null
        /**
         * If this is an alarm based on an anomaly detection model, make this value match the ID of the `ANOMALY_DETECTION_BAND` function.
         *
         * For an example of how to use this parameter, see the **Anomaly Detection Model Alarm** example on this page.
         *
         * If your alarm uses this parameter, it cannot have Auto Scaling actions.
         */
        public var thresholdMetricId: kotlin.String? = null
        /**
         * Sets how this alarm is to handle missing data points. If `TreatMissingData` is omitted, the default behavior of `missing` is used. For more information, see [Configuring How CloudWatch Alarms Treats Missing Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
         *
         * Valid Values: `breaching | notBreaching | ignore | missing`
         *
         * Alarms that evaluate metrics in the `AWS/DynamoDB` namespace always `ignore` missing data even if you choose a different option for `TreatMissingData`. When an `AWS/DynamoDB` metric has missing data, alarms that evaluate that metric remain in their current state.
         */
        public var treatMissingData: kotlin.String? = null
        /**
         * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data points that specify a unit of measure, such as Percent, are aggregated separately.
         *
         * If you don't specify `Unit`, CloudWatch retrieves all unit types that have been published for the metric and attempts to evaluate the alarm. Usually, metrics are published with only one unit, so the alarm works as intended.
         *
         * However, if the metric is published with multiple types of units and you don't specify a unit, the alarm's behavior is not defined and it behaves predictably.
         *
         * We recommend omitting `Unit` so that you don't inadvertently specify an incorrect unit that is not published for this metric. Doing so causes the alarm to be stuck in the `INSUFFICIENT DATA` state.
         */
        public var unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmRequest) : this() {
            this.actionsEnabled = x.actionsEnabled
            this.alarmActions = x.alarmActions
            this.alarmDescription = x.alarmDescription
            this.alarmName = x.alarmName
            this.comparisonOperator = x.comparisonOperator
            this.datapointsToAlarm = x.datapointsToAlarm
            this.dimensions = x.dimensions
            this.evaluateLowSampleCountPercentile = x.evaluateLowSampleCountPercentile
            this.evaluationPeriods = x.evaluationPeriods
            this.extendedStatistic = x.extendedStatistic
            this.insufficientDataActions = x.insufficientDataActions
            this.metricName = x.metricName
            this.metrics = x.metrics
            this.namespace = x.namespace
            this.okActions = x.okActions
            this.period = x.period
            this.statistic = x.statistic
            this.tags = x.tags
            this.threshold = x.threshold
            this.thresholdMetricId = x.thresholdMetricId
            this.treatMissingData = x.treatMissingData
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmRequest = PutMetricAlarmRequest(this)
    }
}
